( function() {

	'use strict';

	if ( 'object' !== typeof vc || 'function' !== typeof vc.shortcode_view ) {
		return false;
	}

	window.vcexToggleView = vc.shortcode_view.extend( {
		changeShortcodeParams: function( model ) {
			window.vcexToggleView.__super__.changeShortcodeParams.call( this, model );
			const thisEl    = this.$el[0];
			const heading   = model.getParam( 'heading' );
			const headingEl = thisEl.querySelector( '.wpb_element_title' );
			const target    = this.$el[0].querySelector( '.vcex-heading-text > span' );
			if ( heading && _.isString( heading ) && ! heading.match(/^#E\-8_/) ) {
				target.textContent = ': ' + heading;
			} else {
				target.textContent = '';
			}
			if ( headingEl ) {
				headingEl.addEventListener( 'click', (e) => {
					const parent = event.target.closest( '.wpb_vcex_toggle' );
					if ( ! parent ) {
						return;
					}
					if ( parent.classList.contains( 'wpb_vcex_toggle--active' ) ) {
						parent.classList.remove( 'wpb_vcex_toggle--active' );
					} else {
						parent.classList.add( 'wpb_vcex_toggle--active' );
					}
				} );
			}
		}
	} );

})();