<?php
namespace TotalThemeCore\Vcex\WPBakery\Views\Backend\Image_Gallery;

defined( 'ABSPATH' ) || exit;

/**
 * Custom view for displaying shortcode image gallery in the WPBakery backend editor.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class View {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Image_Gallery.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->register_actions();
		}
		return static::$instance;
	}

	/**
	 * Register actions.
	 */
	public function register_actions() {
		add_action( 'wp_ajax_vcex_wpbakery_backend_view_image_gallery', [ $this, 'generate'] );
	}

	/**
	 * AJAX callback.
	 */
	public function generate() {
		if ( ! function_exists( 'vc_user_access' ) ) {
			wp_die();
		}

		vc_user_access()->checkAdminNonce()->validateDie()->wpAny( 'edit_posts', 'edit_pages' )->validateDie();

		$post_id      = (int) vc_post_param( 'post_id' );
		$image_ids    = vc_post_param( 'imageIds' );
		$post_gallery = vc_post_param( 'postGallery' );
		$custom_field = vc_post_param( 'customField' );
		$return       = [];
		$images       = '';

		if ( $image_ids ) {
			$images = $image_ids;
		}

		if ( $custom_field && $post_id ) {
			if ( function_exists( 'get_field_object' ) && str_starts_with( $custom_field, 'field_' ) ) {
				$field_obj = get_field_object( $custom_field );
				if ( ! empty( $field_obj['type'] )
					&& 'gallery' === $field_obj['type']
					&& ! empty( $field_obj['name'] )
				) {
					$custom_field = $field_obj['name'];
				}
			}
			$custom_images = get_post_meta( $post_id, $custom_field, true );
			if ( $custom_images ) {
				$images = $custom_images;
			}
		}

		if ( 'true' === $post_gallery && $post_id && function_exists( 'wpex_get_gallery_ids' ) ) {
			$gallery_images = wpex_get_gallery_ids( $post_id );
			if ( $gallery_images ) {
				$images = $gallery_images;
			}
		}

		if ( $images ) {
			if ( is_string( $images ) ) {
				$images = explode( ',', $images );
			}
			if ( $images && is_array( $images ) ) {
				$i = 0;
				foreach( $images as $image_id ) {
					if ( $i++ > 100 ) {
						break; // don't show too many images.
					}
					$return[] = esc_url( wp_get_attachment_image_url( $image_id, 'thumbnail' ) );
				}
			}
		}
		echo json_encode( $return );
		wp_die();
	}

}