<?php
namespace TotalThemeCore\Vcex\WPBakery\Views\Backend\Image_Before_After;

defined( 'ABSPATH' ) || exit;

/**
 * Custom view for displaying images in the WPBakery backend editor.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class View {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Image_Before_After.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->register_actions();
		}
		return static::$instance;
	}

	/**
	 * Register actions.
	 */
	public function register_actions() {
		add_action( 'wp_ajax_vcex_wpbakery_backend_view_image_before_after', [ $this, 'ajax_callback' ] );
	}

	/**
	 * AJAX request.
	 */
	public function ajax_callback() {
		if ( ! function_exists( 'vc_user_access' ) ) {
			wp_die();
		}

		vc_user_access()->checkAdminNonce()->validateDie()->wpAny( 'edit_posts', 'edit_pages' )->validateDie();

		$return = [];
		$post_id = (int) vc_post_param( 'post_id' );
		$source = vc_post_param( 'source' );
		$before_image = $after_image = '';

		switch ( $source ) {
			case 'featured':
				$before_image = get_post_thumbnail_id( $post_id );
				if ( function_exists( 'wpex_get_secondary_thumbnail' ) ) {
					$after_image = wpex_get_secondary_thumbnail( $post_id );
				}
				break;
			case 'custom_field':
				$before_image_id = vc_post_param( 'beforeImageCf' );
				if ( str_starts_with( $before_image_id , 'field_' ) && function_exists( 'get_field' ) ) {
					$before_image = vcex_acf_utils()->get_field_image_id( $before_image_id, $post_id );
				} else {
					$before_image = get_post_meta( $post_id, $before_image_id, true );
				}
				$after_image_id = vc_post_param( 'afterImageCf' );
				if ( str_starts_with( $after_image_id , 'field_' ) && function_exists( 'get_field' ) ) {
					$after_image = vcex_acf_utils()->get_field_image_id( $after_image_id, $post_id );
				} else {
					$after_image = get_post_meta( $post_id, $after_image_id, true );
				}
				break;
			case 'media_library';
			default:
				$before_image = vc_post_param( 'beforeImage' );
				$after_image  = vc_post_param( 'afterImage' );
				break;
		}

		if ( $before_image ) {
			$before_image = esc_url( wp_get_attachment_image_url( $before_image, 'thumbnail' ) );
			if ( $before_image ) {
				$return['beforeImage'] = $before_image;
			}
		}

		if ( $after_image ) {
			$after_image = esc_url( wp_get_attachment_image_url( $after_image, 'thumbnail' ) );
			if ( $after_image ) {
				$return['afterImage'] = $after_image;
			}
		}

		echo json_encode( $return );

		wp_die();
	}

}