( function() {
	'use strict';

	if ( 'object' !== typeof vc || 'function' !== typeof vc.shortcode_view ) {
		return false;
	}

	window.vcexBackendViewCustomField = vc.shortcode_view.extend( {
		changeShortcodeParams: function( model ) {
			window.vcexBackendViewCustomField.__super__.changeShortcodeParams.call( this, model );
			const self = this;
			const field_name = _.isString( model.getParam( 'name' ) ) ? model.getParam( 'name' ) : '';
			const $adminLabel = self.$el.find( '.vc_admin_label.admin_label_name' );
			if ( ! field_name || ! field_name.startsWith( 'field_' ) ) {
				return;
			}
			const xhr = new XMLHttpRequest();
			const data = ''
				+ 'action=vcex_wpbakery_backend_view_custom_field'
				+ '&field_name=' + field_name
				+ '&_vcnonce=' + window.vcAdminNonce;

			xhr.onload = function() {
				if ( 4 == xhr.readyState && 200 == xhr.status ) {
					if ( ! this.responseText ) {
						return;
					}
					$adminLabel.html( '<label>' + $adminLabel.find( 'label' ).text() + '</label>: ' + this.responseText );
				} else {
					console.log( this.responseText );
				}

			};
			xhr.open( 'POST', window.ajaxurl, true );
			xhr.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8' );
			xhr.send( data );
		}
	} );

})();