<?php
namespace TotalThemeCore\Vcex\WPBakery;

defined( 'ABSPATH' ) || exit;

/**
 * Returns shortcode params.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Shortcode_Params {

	/**
	 * Return Shortcode params.
	 */
	public static function get( $shortcode_class ) {
		if ( ! is_callable( $shortcode_class . '::get_params' ) ) {
			return;
		}
		$params = call_user_func( $shortcode_class . '::get_params' );
		if ( is_array( $params ) ) {
			foreach ( $params as $param_k => $param_v ) {
				if ( isset( $param_v['editors'] ) ) {
					if ( ! in_array( 'wpbakery', $param_v['editors'] ) ) {
						unset( $params[$param_k] );
					}
				}
				// Remove Total specific params to prevent any possible conflicts.
				unset( $params[$param_k]['elementor'] );
				unset( $params[$param_k]['editors'] );
				unset( $params[$param_k]['css'] );
			}
		}
		$params = array_values( $params ); // fixes keys after unsetting - !!! important !!!
		return $params;
	}

}