<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use VCEX_Testimonials_Slider_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Testimonials_Slider {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ __CLASS__, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ __CLASS__, 'map' ] );

		$vc_action = vc_request_param( 'action' );

		if ( 'vc_get_autocomplete_suggestion' === $vc_action || 'vc_edit_form' === $vc_action ) {

			// Get autocomplete suggestion
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_include_categories_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Testimonial_Categories::callback'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_exclude_categories_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Testimonial_Categories::callback'
			);

			// Render autocomplete suggestions
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_include_categories_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Testimonial_Categories::render'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_exclude_categories_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Testimonial_Categories::render'
			);

		}

		if ( 'vc_edit_form' === $vc_action ) {
			add_filter( 'vc_edit_form_fields_attributes_' . Shortcode::TAG, [ __CLASS__, 'edit_form_fields' ] );
		}

	}

	/**
	 * Parse old shortcode attributes.
	 */
	public static function edit_form_fields( $atts ) {
		if ( ! empty( $atts['animation'] ) && 'fade' === $atts['animation'] ) {
			$atts['animation'] = 'fade_slides';
		}
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return [
			'name'        => Shortcode::get_title(),
			'description' => esc_html__( 'Recent testimonials slider', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--testimonial',
			'params'      => Shortcode_Params::get( 'VCEX_Testimonials_Slider_Shortcode' ),
		];
	}

}