<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use VCEX_Pricing_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Pricing {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, array( __CLASS__, 'map' ) );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_' . Shortcode::TAG, array( __CLASS__, 'edit_form_fields' ) );
		}
	}

	/**
	 * Alter module fields on edit.
	 */
	public static function edit_form_fields( $atts ) {

		if ( ! empty( $atts['button_url'] )
			&& false === strpos( $atts['button_url'], 'url:' )
			&& '|' != $atts['button_url']
			&& '||' != $atts['button_url']
			&& '|||' != $atts['button_url']
		) {
			$url = 'url:' . rawurlencode( $atts['button_url'] ) . '|';
			$atts['button_url'] = $url;
		}

		$atts = vcex_parse_icon_param( $atts, 'button_icon_left' );
		$atts = vcex_parse_icon_param( $atts, 'button_icon_right' );

		return $atts;

	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Pricing Table', 'total-theme-core' ),
			'description' => esc_html__( 'Insert a pricing column', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--pricing-table',
			'params'      => Shortcode_Params::get( 'VCEX_Pricing_Shortcode' ),
		);
	}

}