<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

defined( 'ABSPATH' ) || exit;

use VCEX_Newsletter_Shortcode as Shortcode;
use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @version 1.4.6
 */
final class Newsletter_Form {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', __CLASS__ . '::vc_after_mapping' );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, __CLASS__ . '::map' );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_' . Shortcode::TAG, __CLASS__ . '::edit_fields', 10 );
		}
	}

	/**
	 * Edit form fields.
	 */
	public static function edit_fields( $atts ) {
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => Shortcode::get_title(),
			'description' => esc_html__( 'Newsletter subscription form', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--newsletter',
			'params'      => Shortcode_Params::get( 'VCEX_Newsletter_Shortcode' ),
		);
	}

}