<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Vcex_Navbar_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Navbar {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ]);
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );

		$vc_action = vc_request_param( 'action' );

		if ( 'vc_get_autocomplete_suggestion' === $vc_action || 'vc_edit_form' === $vc_action ) {
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_taxonomy_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::callback'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_taxonomy_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::render'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_filter_active_item_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::callback'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_filter_active_item_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::render'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_terms_not_in_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::callback'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_terms_not_in_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::render'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_child_of_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Parent_Terms::callback'
			);
			add_filter(
				'vc_autocomplete_' . Shortcode::TAG . '_child_of_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Parent_Terms::render'
			);
		}

		if ( 'vc_edit_form' === $vc_action ) {
			add_filter( 'vc_edit_form_fields_attributes_' . Shortcode::TAG, [ $this, 'edit_fields' ] );
		}
	}

	/**
	 * Edif form fields.
	 */
	public function edit_fields( $atts ) {
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'        => Shortcode::get_title(),
			'description' => esc_html__( 'Custom menu navigation bar', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'icon'        => 'vcex_element-icon vcex_element-icon--navbar',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'Vcex_Navbar_Shortcode' ),
		];
	}

}