<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Image_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;
use TotalThemeCore\Vcex\WPBakery\Views\Backend\Image\View as Backend_View;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Image {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );

		if ( is_admin() ) {
			Backend_View::instance();
		}
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_image', [ $this, 'edit_fields' ], 10 );
		}
	}

	/**
	 * Edit form fields.
	 */
	public function edit_fields( $atts ) {
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return array(
			'name'             => esc_html__( 'Image', 'total-theme-core' ),
			'description'      => esc_html__( 'Single Image', 'total-theme-core' ),
			'base'             => Shortcode::TAG,
			'category'         => vcex_shortcodes_branding(),
			'icon'             => 'vcex_element-icon vcex_element-icon--image',
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'image' ),
			'js_view'          => 'vcexBackendViewImage',
			'params'           => Shortcode_Params::get( 'VCEX_Image_Shortcode' ),
		);
	}

}