<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Image_Grid as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;
use TotalThemeCore\Vcex\WPBakery\Views\Backend\Image_Gallery\View as Backend_View;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Image_Grid {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );

		if ( is_admin() ) {
			Backend_View::instance();
		}
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_image_grid', [ $this, 'edit_form_fields' ] );
		}
	}

	/**
	 * Update fields on edit.
	 */
	public function edit_form_fields( $atts ) {
		if ( empty( $atts['img_border_radius'] ) && isset( $atts['rounded_image'] ) ) {
			if ( 'yes' === $atts['rounded_image'] || 'true' == $atts['rounded_image'] ) {
				$atts['img_border_radius'] = 'round';
			}
			unset( $atts['rounded_image'] );
		}
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'             => esc_html__( 'Image Grid', 'total-theme-core' ),
			'description'      => esc_html__( 'Responsive image gallery', 'total-theme-core' ),
			'base'             => Shortcode::TAG,
			'icon'             => 'vcex_element-icon vcex_element-icon--image-gallery',
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'image-gallery' ),
			'js_view'          => 'vcexBackendViewImageGallery',
			'category'         => vcex_shortcodes_branding(),
			'params'           => Shortcode_Params::get( 'VCEX_Image_Grid' ),
		];
	}

}