<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Image_Before_After_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;
use TotalThemeCore\Vcex\WPBakery\Views\Backend\Image_Before_After\View as Backend_View;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.6.0
 */
final class Image_Before_After {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );

		if ( is_admin() ) {
			Backend_View::instance();
		}
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'             => Shortcode::get_title(),
			'description'      => esc_html__( 'Visual difference between two images', 'total-theme-core' ),
			'base'             => Shortcode::TAG,
			'icon'             => 'vcex_element-icon vcex_element-icon--before-after',
			'category'         => vcex_shortcodes_branding(),
			'params'           => Shortcode_Params::get( 'VCEX_Image_Before_After_Shortcode' ),
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'image-before-after' ),
			'js_view'          => 'vcexBackendViewImageBeforeAfter',
		];
	}

}