<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use VCEX_Feature_Box_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Feature_Box {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_feature_box', array( __CLASS__, 'edit_fields' ), 10 );
		}
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, array( __CLASS__, 'map' ) );
	}

	/**
	 * Edit form fields.
	 */
	public static function edit_fields( $atts ) {
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Feature Box', 'total-theme-core' ),
			'description' => esc_html__( 'Side content and image', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--feature-box',
			'params'      => Shortcode_Params::get( 'VCEX_Feature_Box_Shortcode' ),
		);
	}

}