<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use VCEX_Divider_Dots_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Divider_Dots {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( 'vcex_divider_dots', array( __CLASS__, 'map' ) );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_divider_dots', array( __CLASS__, 'edit_form_fields' ) );
		}

	}

	/**
	 * Edit form fields.
	 */
	public static function edit_form_fields( $atts ) {
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;

	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Divider Dots', 'total-theme-core' ),
			'description' => esc_html__( 'Dot Separator', 'total-theme-core' ),
			'base'        => 'vcex_divider_dots',
			'icon'        => 'vcex_element-icon vcex_element-icon--divider-dots',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_Divider_Dots_Shortcode' ),
		);
	}

}