<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;
use TotalThemeCore\Vcex\WPBakery\Views\Backend\Custom_Field\View as Backend_View;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 */
final class Custom_Field {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );

		if ( is_admin() ) {
			Backend_View::instance();
		}
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( 'vcex_custom_field', [ $this, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'             => esc_html__( 'Custom Field', 'total-theme-core' ),
			'description'      => esc_html__( 'Display custom field meta value', 'total-theme-core' ),
			'base'             => 'vcex_custom_field',
			'icon'             => 'vcex_element-icon vcex_element-icon--custom-field',
			'js_view'          => 'vcexBackendViewCustomField',
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'custom-field' ),
			'category'         => vcex_shortcodes_branding(),
			'params'           => Shortcode_Params::get( 'VCEX_Custom_Field_Shortcode' ),
		];
	}

}