<?php
/**
 * vcex_teaser shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

// Define output var.
$output = '';

// Get shortcode attributes.
$atts = vcex_shortcode_atts( 'vcex_teaser', $atts, 'VCEX_Teaser_Shortcode' );

// Define vars.
$style         = ! empty( $atts['style'] ) ? $atts['style'] : '';
$heading       = ! empty( $atts['heading'] ) ? $atts['heading'] : '';
$css_animation = ! empty( $atts['css_animation'] ) ? $atts['css_animation'] : '';
$image_source  = ! empty( $atts['image_source'] ) ? $atts['image_source'] : 'media_library';
$visibility    = ! empty( $atts['visibility'] ) ? $atts['visibility'] : '';
$onclick_el    = $atts['onclick_el'] ?? '';
$url_wrap      = ( 'container' === $onclick_el ) ? true: false;
$show_button   = vcex_validate_att_boolean( 'show_button', $atts );

if ( $show_button && ! $url_wrap ) {
	$onclick_el = 'button';
}

// Generate url.
$url = $atts['url'] ?? '';

if ( is_array( $url ) ) {
	$url = $url['url']; // Elementor check.
}

if ( $url && '||' !== $url && '|||' !== $url ) {

	// Disable URL wrap if the content has a link to prevent conflicts.
	if ( $url_wrap && false !== strpos( $content, '<a href=' ) ) {
		$url_wrap = false;
	}

	// Deprecated attributes.
	$url_title = $url_title ?? '';
	$url_target = $url_target ?? '';

	// Elementor attributes.
	if ( is_array( $atts['url'] ) ) {
		$url_title  = $atts['url']['title'] ?? $url_title;
		if ( isset( $atts['url']['is_external'] ) && vcex_validate_boolean( $atts['url']['is_external'] ) ) {
			$url_target = '_blank';
		}
		if ( isset( $atts['url']['nofollow'] ) && vcex_validate_boolean( $atts['url']['nofollow'] ) ) {
			$url_rel = 'nofllow';
		}
	}

	// Shortcode attributes.
	else {
		$url_atts = vcex_build_link( $url );
		if ( ! empty( $url_atts['url'] ) ) {
			$url        = $url_atts['url'] ?? $url;
			$url_title  = $url_atts['title'] ?? $url_title;
			$url_target = $url_atts['target'] ?? $url_target;
		}
	}

	// Title fallback (shouldn't be an empty title).
	$url_title = $url_title ?: $heading;

	// Link classes.
	$url_classes = 'wpex-no-underline';

	// Sanitize target.
	if ( 'true' === $atts['url_local_scroll'] ) {
		$url_classes .= ' local-scroll-link';
		$url_target = '';
	}

	if ( $url_wrap ) {
		$url_classes .= ' vcex-teaser-link-wrap wpex-flex';
		if ( $css_animation && 'none' !== $css_animation ) {
			$url_classes .= ' wpex-flex-grow';
		}
		$url_classes .= ' wpex-inherit-color';
		$url_classes .= ' wpex-no-underline';
		if ( $visibility ) {
			$url_classes .= ' ' . vcex_parse_visibility_class( $visibility );
		}
	}

	// Define url attributes.
	$url_attrs = array(
		'href'   => esc_url( do_shortcode( $url ) ),
		'title'  => esc_attr( do_shortcode( $url_title ) ),
		'class'  => esc_attr( $url_classes ),
		'target' => $url_target,
		'rel'    => $url_rel ?? $url_atts['rel'] ?? '',
	);

	$url_output = '<a' . vcex_parse_html_attributes( $url_attrs ) . '>';

} // End url sanitization

// Add main Classes.
$wrap_classes = array(
	'vcex-module',
	'vcex-teaser',
);

if ( $style ) {
	$wrap_classes[] = 'vcex-teaser-' . sanitize_html_class( $style );
}

if ( $show_button ) {
	$wrap_classes[] = 'wpex-flex';
	$wrap_classes[] = 'wpex-flex-col';
}

if ( ! empty( $atts['bottom_margin'] ) ) {
	$wrap_classes[] = vcex_sanitize_margin_class( $atts['bottom_margin'], 'wpex-mb-' );
}

if ( ! empty( $atts['shadow'] ) ) {
	$wrap_classes[] = vcex_parse_shadow_class( $atts['shadow'] );
}

if ( ! empty( $atts['classes'] ) ) {
	$wrap_classes[] = vcex_get_extra_class( $atts['classes'] );
}

if ( ! empty( $atts['text_align'] ) ) {
	$wrap_classes[] = 'text' . sanitize_html_class( $atts['text_align'] );
}

if ( $visibility ) {
	$wrap_classes[] = vcex_parse_visibility_class( $visibility );
}

if ( ! empty( trim( $atts['hover_animation'] ?? '' ) ) ) {
	$wrap_classes[] = vcex_hover_animation_class( $atts['hover_animation'] );
	vcex_enque_style( 'hover-animations' );
}

// Style specific classes.
switch( $style ) {
	case 'two':
		$wrap_classes[] = 'wpex-surface-2';
		$wrap_classes[] = 'wpex-p-20';
		if ( empty( $atts['border_radius'] ) ) {
			$wrap_classes[] = 'wpex-rounded';
		}
		break;
	case 'three':
		$wrap_classes[] = 'wpex-surface-2';
		break;
	case 'four':
		$wrap_classes[] = 'wpex-border wpex-border-solid wpex-border-main';
		break;
}

if ( $atts['css'] ) {
	$wrap_classes[] = vcex_vc_shortcode_custom_css_class( $atts['css'] );
}

// Add inline style for main div (uses special code because there are added checks).
$wrap_style = [];

if ( ! empty( $atts['padding'] ) && ( 'two' === $style || 'three' === $style ) ) {
	$wrap_style['padding'] = $atts['padding'];
}

if ( ! empty( $atts['background'] ) ) {
	if ( 'two' === $style || ( 'three' === $style && empty( $atts['content_background'] ) ) ) {
		$wrap_style['background'] = $atts['background'];
	}
}

if ( ! empty( $atts['border_color'] ) ) {
	$wrap_style['border_color'] = $atts['border_color'];
}

if ( ! empty( $atts['border_radius'] ) ) {
	$wrap_style['border_radius'] = $atts['border_radius'];
}

$wrap_style = vcex_inline_style( $wrap_style );

// Media and Content classes for different styles.
$media_classes   = [
	'vcex-teaser-media'
];

$content_classes = 'vcex-teaser-content';

if ( $show_button ) {
	$content_classes .= ' wpex-flex wpex-flex-grow wpex-flex-col';
}

if ( in_array( $style, array( 'three', 'four' ) )
	|| ( ! empty( $atts['shadow'] ) ) && in_array( $style, array( '', 'one' ) )
) {
	$content_classes .= ' wpex-p-20';
} elseif ( empty( $atts['img_bottom_margin'] ) ) {
	$media_classes[] = 'wpex-mb-20';
}

if ( ! empty( $atts['img_bottom_margin'] ) ) {
	$media_classes[] = vcex_parse_margin_class( $atts['img_bottom_margin'], 'mb-' );
}

// Parse wrap classes.
$wrap_classes = vcex_parse_shortcode_classes( $wrap_classes, 'vcex_teaser', $atts );

/*-------------------------------------------------------------------------------*/
/* [ Begin Output ]
/*-------------------------------------------------------------------------------*/


// Open css_animation element (added in it's own element to prevent conflicts with inner styling).
if ( $css_animation && 'none' !== $css_animation ) {

	$animation_classes = array( trim( vcex_get_css_animation( $css_animation ) ) );

	if ( $atts['visibility'] ) {
		$animation_classes[] = vcex_parse_visibility_class( $atts['visibility'] );
	}

	$css_animation_style = vcex_inline_style( array(
		'animation_delay' => $atts['animation_delay'],
		'animation_duration' => $atts['animation_duration'],
	) );

	$output .= '<div class="' . esc_attr( implode( ' ', $animation_classes ) ) . '"' . $css_animation_style . '>';

}

if ( $url_wrap && ! empty( $url_output ) ) {
	$output .= $url_output;
}

// Open main module element.
$output .= '<div class="' . esc_attr( $wrap_classes ) . '"' . vcex_get_unique_id( $atts['unique_id'] ) . $wrap_style . '>';

	/*-------------------------------------------------------------------------------*/
	/* [ Display Video ]
	/*-------------------------------------------------------------------------------*/
	if ( ! empty( $atts['video'] ) ) {

		if ( ! empty( $atts['img_border_radius'] ) ) {
			$img_border_radius_class = vcex_parse_border_radius_class( $atts['img_border_radius'] );
			if ( $img_border_radius_class ) {
				$media_classes[] = $img_border_radius_class;
				$media_classes[] = 'wpex-overflow-hidden';
			}
		}

		$output .= '<div class="' . esc_attr( implode( ' ', $media_classes ) ) . ' responsive-video-wrap">';

			if ( apply_filters( 'wpex_has_oembed_cache', true ) ) { // filter added for testing purposes.
				global $wp_embed;
				if ( $wp_embed && is_object( $wp_embed ) ) {
					$video_html = $wp_embed->shortcode( [], wp_strip_all_tags( $atts['video'] ) );
					// Check if output is a shortcode because if the URL is self hosted
					// it will pass through wp_embed_handler_video which returns a video shortcode
					if ( ! empty( $video_html )
						&& is_string( $video_html )
						&& str_starts_with( $video_html, '[video' )
					) {
						$video_html = do_shortcode( $video_html );
					}
					$output .= $video_html;
				}
			} else {
				$video_html = wp_oembed_get( wp_strip_all_tags( $atts['video'] ) );
				if ( ! empty( $video_html ) && ! is_wp_error( $video_html ) ) {
					$output .= '<div class="wpex-responsive-media">' . $video_html . '</div>';
				}
			}

		$output .= '</div>';

	}

	/*-------------------------------------------------------------------------------*/
	/* [ Image ]
	/*-------------------------------------------------------------------------------*/
	if ( ! empty( $atts['image'] ) || ! empty( $atts['external_image'] ) ) {

		// Image classes.
		if ( ! empty( $atts['img_filter'] ) ) {
			$media_classes[] = vcex_image_filter_class( $atts['img_filter'] );
		}

		if ( ! empty( $atts['img_hover_style'] ) ) {
			$media_classes[] = vcex_image_hover_classes( $atts['img_hover_style'] );
		}

		if ( ! empty( $atts['img_align'] ) ) {
			$media_classes[] = 'text' . sanitize_html_class( $atts['img_align'] );
		}

		if ( ! empty( $atts['img_style'] ) && 'stretch' === $atts['img_style'] ) {
			$media_classes[] = 'stretch-image';
		}

		$output .= '<div class="' . esc_attr( implode( ' ', $media_classes ) ) . '">';

			if ( ! $onclick_el && ! empty( $url_output ) ) {
				$output .= $url_output;
			}

			$image_class = 'wpex-align-middle';

			if ( ! empty( $atts['img_border_radius'] ) ) {
				$img_border_radius_class = vcex_parse_border_radius_class( $atts['img_border_radius'] );
				if ( $img_border_radius_class ) {
					$image_class .= ' ' . $img_border_radius_class;
				}
			}

			if ( 'media_library' === $image_source ) {

				$image = $atts['image'] ?? null;

				if ( is_array( $image ) ) {
					$image = $image['id'] ?? $image['attachment'] ?? null;
				}

				if ( $image ) {
					$output .= vcex_get_post_thumbnail( array(
						'attachment' => $image,
						'crop'       => $atts['img_crop'] ?? '',
						'size'       => $atts['img_size'] ?? '',
						'width'      => $atts['img_width'] ?? '',
						'height'     => $atts['img_height'] ?? '',
						'alt'        => $atts['image_alt'] ?: $heading,
						'class'      => $image_class,
					) );
				}

			} elseif ( 'external' === $image_source ) {

				if ( ! empty( $atts['external_image'] ) && is_string( $atts['external_image'] ) ) {
					$external_image = trim( $atts['external_image'] );
					if ( $external_image ) {
						$output .= '<img src="' . esc_url( $external_image ) . '" loading="lazy" class="' . esc_attr( $image_class ) . '">';
					}
				}

			}

			if ( ! $onclick_el && ! empty( $url_output ) ) {
				$output .= '</a>';
			}

		$output .= '</div>';

	} // End image output.

	/*-------------------------------------------------------------------------------*/
	/* [ Details ]
	/*-------------------------------------------------------------------------------*/
	if ( $content || $heading ) {

		// Content area
		$content_style = array(
			'margin'     => $atts['content_margin'] ?? null,
			'padding'    => $atts['content_padding'] ?? null,
			'background' => $atts['content_background'] ?? null,
		);

		if ( ! empty( $atts['border_radius'] ) && ( 'three' === $style || 'four' === $style ) ) {
			$content_style['border_radius'] = $atts['border_radius'];
		}

		$content_style = vcex_inline_style( $content_style );

		$output .= '<div class="' . esc_attr( $content_classes ) . '"' . $content_style . '>';

			/*-------------------------------------------------------------------------------*/
			/* [ Heading ]
			/*-------------------------------------------------------------------------------*/
			if ( $heading ) {

				// Heading class.
				$heading_class = array(
					'vcex-teaser-heading',
					'wpex-heading',
					'wpex-text-lg',
				);

				// Heading responsive styles.
				$unique_classname = vcex_element_unique_classname();

				$el_responsive_styles = array(
					'font_size' => $atts['heading_size'] ?? null,
				);

				$responsive_css = vcex_element_responsive_css( $el_responsive_styles, $unique_classname );

				if ( $responsive_css ) {
					$heading_class[] = $unique_classname;
					$output .= '<style>' . $responsive_css . '</style>';
				}

				// Heading style.
				$heading_inline_style = vcex_inline_style( array(
					'font_family'    => $atts['heading_font_family'] ?? null,
					'color'          => $atts['heading_color'] ?? null,
					'font_size'      => $atts['heading_size'] ?? null,
					'margin'         => $atts['heading_margin'] ?? null,
					'font_weight'    => $atts['heading_weight'] ?? null,
					'letter_spacing' => $atts['heading_letter_spacing'] ?? null,
					'text_transform' => $atts['heading_transform'] ?? null,
				), false );

				// Heading attributes.
				$heading_attrs = array(
					'class' => $heading_class,
					'style' => $heading_inline_style,
				);

				// Heading output..
				$safe_heading_tag = tag_escape( ! empty( $atts['heading_type'] ) ? $atts['heading_type'] : 'h2' );
				$output .= '<' . $safe_heading_tag . vcex_parse_html_attributes( $heading_attrs ) . '>';

					// Open URL.
					if ( ! $onclick_el && ! empty( $url_output ) ) {
						$output .= $url_output;
					}

						$output .= vcex_parse_text_safe( $heading );

					// Close URL.
					if ( ! $onclick_el && ! empty( $url_output ) ) {
						$output .= '</a>';
					}

				$output .= '</' . $safe_heading_tag . '>';

			} // End heading.

			/*-------------------------------------------------------------------------------*/
			/* [ Content ]
			/*-------------------------------------------------------------------------------*/
			if ( $content ) {

				$content_text_class = [
					'vcex-teaser-text',
					'wpex-mt-' . absint( $atts['content_top_margin'] ?: 10 ),
					'wpex-last-mb-0',
					'wpex-clr',
				];

				if ( ! empty( $url_output ) && $show_button ) {
					$content_text_class[] = 'wpex-mb-20';
				}

				// Content responsive styles.
				$unique_classname = vcex_element_unique_classname();

				$el_responsive_styles = array(
					'font_size' => $atts['content_font_size'] ?? null,
				);

				$responsive_css = vcex_element_responsive_css( $el_responsive_styles, $unique_classname );

				if ( $responsive_css ) {
					$content_text_class[] = $unique_classname;
					$output .= '<style>' . $responsive_css . '</style>';
				}

				// Content inline style.
				$content_text_style = vcex_inline_style( array(
					'font_size'   => $atts['content_font_size'] ?? null,
					'color'       => $atts['content_color'] ?? null,
					'font_weight' => $atts['content_font_weight'] ?? null,
				), false );

				// Content attributes.
				$content_text_attrs = array(
					'class' => $content_text_class,
					'style' => $content_text_style,
				);

				// Output content.
				$output .= '<div' . vcex_parse_html_attributes( $content_text_attrs ) . '>';

					$output .= vcex_the_content( $content );

				$output .= '</div>';

			} // End content output.

			/*-------------------------------------------------------------------------------*/
			/* [ Button ]
			/*-------------------------------------------------------------------------------*/
			if ( ! empty( $url_output ) && $show_button ) {
				$output .= '<div class="vcex-teaser-button-wrap wpex-mt-auto">';
					$button_text = ! empty( $atts['button_text'] ) ? vcex_parse_text_safe( $atts['button_text'] ) : esc_html__( 'Learn more', 'total-theme-core' );
					$button_class = 'vcex-teaser-button theme-button';
					if ( ! empty( $atts['button_class'] ) ) {
						$button_class .= ' ' . trim( esc_attr( $atts['button_class'] ) );
					}
					if ( ! empty( $atts['button_hover_background'] ) ) {
						$btn_hover_bg = $atts['button_hover_background'];
					}
					if ( ! empty( $atts['button_hover_color'] ) ) {
						$btn_hover_color = $atts['button_hover_color'];
					}
					$button_style = vcex_inline_style( [
						'padding'               => $atts['button_padding'] ?? null,
						'font_size'              => $atts['button_font_size'] ?? null,
						'border_radius'          => $atts['button_border_radius'] ?? null,
						'--wpex-btn-color'       => $atts['button_color'] ?? null,
						'--wpex-btn-bg'          => $atts['button_background'] ?? null,
						'--wpex-hover-btn-bg'    => $btn_hover_bg ?? $atts['button_background'] ?? null,
						'--wpex-hover-btn-color' => $btn_hover_color ?? $atts['button_color'] ?? null,
					] );
					if ( $url_wrap ) {
						$output .= '<span class="' . esc_attr( $button_class ) . '"' . $button_style . '>' . $button_text . '</span>';
					} else {
						$button_attrs = [
							'href'   => $url_attrs['href'],
							'title'  => $url_attrs['title'],
							'class'  => $button_class,
							'target' => $url_target,
							'rel'    => $url_rel ?? $url_atts['rel'] ?? '',
							'style'  => $button_style,
						];
						$output .= '<a' . vcex_parse_html_attributes( $button_attrs ) . '>' . $button_text . '</a>';
					}
				$output .= '</div>';
			}

		$output .= '</div>'; // End content

	} // End heading & content display.

$output .= '</div>';

if ( $url_wrap && ! empty( $url_output ) ) {
	$output .= '</a>';
}

if ( $css_animation && 'none' !== $css_animation ) {
	$output .= '</div>';
}

// @codingStandardsIgnoreLine
echo $output;