<?php
/**
 * vcex_star_rating shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'wpex_get_theme_icon_html' ) ) {
	return;
}

$rating = ! empty( $atts['value'] ) ? floatval( $atts['value'] ) : '{{post_rating}}';

$rating = vcex_parse_text_safe( $rating );

if ( empty( $rating ) && '0' !== $rating ) {
	return;
}

$icon       = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : 'ticons';
$scale      = ( $atts['scale'] && in_array( $atts['scale'], [ '0-5', '0-10' ] ) ) ? $atts['scale'] : '0-5';
$max_rating = ( '0-10' === $scale ) ? 10 : 5;

$shortcode_class = [
	'vcex-module',
	'vcex-star-rating',
	// Utility classes
	'wpex-leading-none',
];

$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_star_rating', $atts );

$label_html = '';
$label_position = ! empty( $atts['label_position'] ) ? wp_strip_all_tags( $atts['label_position'] ) : 'top';

if ( ! empty( $atts['label'] ) ) {
	$label = vcex_parse_text_safe( $atts['label'] );
	if ( $label ) {
		$label_class = 'vcex-star-rating__label';
		$label_class .= ' vcex-star-rating__label--' . $label_position;
		$label_html = '<div class="' . esc_attr( $label_class ) . ' wpex-bold">' . $label . '</div>';
	}
}

// Display the shortcode.
$output = '<div class="' . esc_attr( $shortcode_class ) . '">';

	// Display Label.
	if ( $label_html && 'top' == $label_position ) {
		$output .= $label_html;
	}

	$output .= '<div class="vcex-star-rating__inner wpex-inline-flex wpex-flex-wrap wpex-items-center">';

		// Display Label.
		if ( $label_html && 'inline' == $label_position ) {
			$output .= $label_html;
		}

		// Show stars.
		$full_star  = wpex_get_theme_icon_html( $icon . '/star' );
		$half_star  = wpex_get_theme_icon_html( $icon . '/star-half-empty' );
		$empty_star = wpex_get_theme_icon_html( $icon . '/star-empty' );

		$output .= '<div class="vcex-star-rating__stars wpex-flex wpex-flex-wrap wpex-items-center wpex-gap-5">';

			// Integers.
			if ( ( is_numeric( $rating ) && ( intval( $rating ) == floatval( $rating ) ) ) ) {
				$output .= str_repeat( $full_star, $rating );
				if ( $rating < $max_rating ) {
					$output .= str_repeat( $empty_star, $max_rating - $rating );
				}

			// Fractions.
			} else {
				$whole_rating = intval( $rating );
				$output .= str_repeat( $full_star, $whole_rating );
				$output .= $half_star;
				if ( $whole_rating < $max_rating ) {
					$output .= str_repeat( $empty_star, ( $max_rating - 1 ) - $whole_rating );
				}
			}

		$output .= '</div>';

		// Display number.
		if ( vcex_validate_att_boolean( 'show_number', $atts ) ) {
			$output .= '<div class="vcex-star-rating__number wpex-ml-5">(' . floatval( $rating  ) . '/' . absint( $max_rating ) . ')</div>';
		}

	$output .= '</div>';

$output .= '</div>';

// @codingStandardsIgnoreLine
echo $output;