<?php
/**
 * vcex_page_title shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

$atts = vcex_shortcode_atts( 'vcex_page_title', $atts, 'VCEX_Page_Title_Shortcode' );

if ( vcex_is_template_edit_mode() ) {
	$title = esc_html( 'Page Title Placeholder', 'total-theme-core' );
} else {
	$title = vcex_get_the_title();
}

if ( empty( $title ) ) {
	return;
}

$custom_width = ! empty( $atts['width'] ) ? $atts['width'] : '';
$tag_escaped  = ! empty( $atts['html_tag'] ) ? tag_escape( $atts['html_tag'] ) : 'h1';
$float        = ! empty( $atts['float'] ) ? sanitize_html_class( $atts['float'] ) : '';
$link_to_post = vcex_validate_att_boolean( 'link_to_post', $atts );

// Define shortcode classes.
$shortcode_class = array(
	'vcex-page-title',
	'vcex-module',
);

if ( $custom_width ) {
	$shortcode_class[] = 'wpex-max-w-100';
	switch( $float ) {
		case 'left':
			$shortcode_class[] = 'wpex-float-left';
			break;
		case 'right':
			$shortcode_class[] = 'wpex-float-right';
			break;
		case 'center':
		default:
			$shortcode_class[] = 'wpex-mx-auto';
			break;
	}
}

// Custom user classes.
$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_page_title' );

if ( $extra_classes ) {
	$shortcode_class = array_merge( $shortcode_class, $extra_classes );
}

// Filters shortcode classes.
$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_page_title', $atts );

// Inline styles.
$shortcode_style = vcex_inline_style( array(
	'width'              => $custom_width,
	'animation_delay'    => $atts['animation_delay'] ?? '',
	'animation_duration' => $atts['animation_duration'] ?? '',
), true );

// Begin output.
$output = '<div class="' . esc_attr( trim( $shortcode_class ) ) . '"' . $shortcode_style . '>';

	if ( $link_to_post ) {
		$output .= '<a href="' . esc_url( get_permalink( vcex_get_the_ID() ) ) . '" class="vcex-page-title__link wpex-no-underline wpex-inherit-color">';
	}

	// Inner heading classes.
	$heading_classes = array(
		'vcex-page-title__heading',
		'wpex-heading',
		'wpex-text-3xl',
	);

	// Inline heading style.
	$heading_style = vcex_inline_style( [
		'color'          => $atts['color'] ?? '',
		'font_family'    => $atts['font_family'] ?? '',
		'font_size'      => $atts['font_size'] ?? '',
		'line_height'    => $atts['line_height'] ?? '',
		'font_weight'    => $atts['font_weight'] ?? '',
		'text_transform' => $atts['text_transform'] ?? '',
		'letter_spacing' => $atts['letter_spacing'] ?? '',
	], true );

	// Responsive heading font size.
	if ( ! empty( $atts['font_size'] ) ) {
		$unique_classname = vcex_element_unique_classname();

		$responsive_css = vcex_element_responsive_css( array(
			'font_size' => $atts['font_size'],
		), $unique_classname );

		if ( $responsive_css ) {
			$heading_classes[] = $unique_classname;
			$output .= '<style>' . $responsive_css . '</style>';
		}
	}

	// Display the heading.
	$output .= '<' . $tag_escaped . ' class="' . implode( ' ', $heading_classes ) . '"' . $heading_style . '>';

		// Before text.
		if ( ! empty( $atts['before_text'] ) ) {
			$output .= '<span class="vcex-page-title__before">' . vcex_parse_text_safe( $atts['before_text'] ) . '</span> ';
		}

		// The page title.
		$output .= '<span class="vcex-page-title__text">' . vcex_parse_text_safe( $title ) . '</span>';

		// After text.
		if ( ! empty( $atts['after_text'] ) ) {
			$output .= ' <span class="vcex-page-title__after">' . vcex_parse_text_safe( $atts['after_text'] ) . '</span>';
		}

	$output .= '</' . $tag_escaped . '>';

	if ( $link_to_post ) {
		$output .= '</a>';
	}

$output .= '</div>';

if ( $custom_width && 'center' !== $float ) {
	$output .= '<div class="vcex-clear--page_title wpex-clear"></div>';
}

// @codingStandardsIgnoreLine
echo $output;