<?php
/**
 * vcex_newsletter_form shortcode output
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5
 */

defined( 'ABSPATH' ) || exit;

// Main variables.
$output           = '';
$stack_fields     = vcex_validate_att_boolean( 'stack_fields', $atts, false );
$placeholder_text = ! empty( $atts['placeholder_text'] ) ? $atts['placeholder_text'] : esc_html__( 'Enter your email address', 'total-theme-core' );

// Wrapper classes.
$shortcode_class = [
	'vcex-newsletter-form',
];

if ( $stack_fields ) {
	$shortcode_class[] = 'vcex-newsletter-form--stacked';
}

$shortcode_class[] = 'vcex-module';
$shortcode_class[] = 'wpex-flex';
$shortcode_class[] = 'wpex-max-w-100'; // prevent issues with flex wraps when using the flex container.

if ( ! empty( $atts['input_align'] ) ) {
	switch ( $atts['input_align'] ) {
		case 'left':
			$shortcode_class[] = 'wpex-justify-start';
			break;
		case 'center':
			$shortcode_class[] = 'wpex-justify-center';
			break;
		case 'right':
			$shortcode_class[] = 'wpex-justify-end';
			break;
	}
}

if ( ! empty( $atts['bottom_margin'] ) ) {
	$shortcode_class[] = vcex_sanitize_margin_class( $atts['bottom_margin'], 'wpex-mb-' );
}

if ( vcex_validate_att_boolean( 'fullwidth_mobile', $atts, false ) && ! $stack_fields ) {
	$shortcode_class[] = 'vcex-fullwidth-mobile';
}

if ( ! empty( $atts['classes'] ) ) {
	$shortcode_class[] = vcex_get_extra_class( $atts['classes'] );
}

if ( ! empty( $atts['visibility'] ) ) {
	$shortcode_class[] = vcex_parse_visibility_class( $atts['visibility'] );
}

if ( ! empty( $atts['css_animation'] ) ) {
	$shortcode_class[] = vcex_get_css_animation( $atts['css_animation'] );
}

$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_newsletter_form', $atts );

// Begin output.
$output .= '<div class="' . esc_attr( $shortcode_class ) . '"' . vcex_get_unique_id( $atts ) . '>';

	$form_wrap_class = 'vcex-newsletter-form-wrap wpex-max-w-100';

	if ( empty( $atts['input_width'] ) ) {
		$form_wrap_class .= ' wpex-flex-grow';
	}

	$output .= '<div class="' . esc_attr( $form_wrap_class ) . '">';

		$form_class = 'wpex-flex';

		if ( $stack_fields ) {
			$form_class .= ' wpex-flex-col';
			if ( empty( $atts['gap'] ) ) {
				$atts['gap'] = '10';
			}
		}

		if ( ! empty( $atts['gap'] ) ) {
			$form_class .= ' wpex-gap-' . sanitize_html_class( absint( $atts['gap'] ) );
		}

		/**
		 * Filters the vcex_newsletter_form action url.
		 *
		 * @param string $form_action
		 * @param array $shortcode_attributes
		 */
		$form_action = (string) apply_filters( 'vcex_newsletter_form_action_url', $atts['form_action'], $atts );

		$output .= '<form action="' . esc_url( $form_action ) . '" method="post" class="' . esc_attr( $form_class ) . '">';

			if ( ! empty( $atts['input_label'] ) ) {
				//@todo Add support for input labels.
			} else {
				$output .= '<label class="vcex-newsletter-form-label wpex-flex-grow">';
				$output .= '<span class="screen-reader-text">' . esc_html( $placeholder_text ) . '</span>';
			}

				$input_name = ! empty( $atts['input_name'] ) ? $atts['input_name'] : 'EMAIL';

				$output .= '<input type="email" name="' . esc_attr( $input_name ) . '" placeholder="' . esc_attr( $placeholder_text ) . '" autocomplete="off" required>';

			if ( empty( $atts['input_label'] ) ) {
				$output .= '</label>';
			}

			/** Hidden Fields **/
			if ( ! empty( $atts['hidden_fields'] ) ) {
				$hidden_fields = $atts['hidden_fields'];
				$hidden_fields = explode( ',', $hidden_fields );
				if ( is_array( $hidden_fields ) ) {
					foreach( $hidden_fields as $field ) {
						$field_attrs = explode( '|', $field );
						if ( isset( $field_attrs[0] ) && isset( $field_attrs[1] ) ) {
							$output .= '<input type="hidden" name="' . esc_attr( $field_attrs[0] ) . '" value="' . esc_attr( $field_attrs[1] ) . '">';
						}
					}
				}
			}

			ob_start();
				do_action( 'vcex_newsletter_form_extras' );
			$output .= ob_get_clean();

			/** Submit Button ***/
			$submit_text = ! empty( $atts['submit_text'] ) ? $atts['submit_text'] : esc_html__( 'Sign Up', 'total-theme-core' );

			if ( $submit_text ) {

				$submit_class = 'vcex-newsletter-form-button';

				if ( $stack_fields ) {
					$submit_class .= ' vcex-newsletter-form-button--min-height';
				}

				$submit_class .= ' wpex-flex-shrink-0';

				if ( empty( $atts['submit_text_transform'] ) && empty( $atts['submit_letter_spacing'] ) ) {
					$submit_class .= ' wpex-tracking-wider';
				}

				$output .= '<button type="submit" value="" class="' . esc_attr( trim( $submit_class) ) . '">';

					$output .= do_shortcode( wp_kses_post( $submit_text ) );

				$output .= '</button>';

			}

		$output .= '</form>';

	$output .= '</div>';

$output .= '</div>';

echo $output; // @codingStandardsIgnoreLine