<?php
/**
 * vcex_list_item shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

// Get and extract shortcode attributes.
$atts = vcex_shortcode_atts( 'vcex_list_item', $atts, 'VCEX_List_Item_Shortcode' );
extract( $atts );

// Sanitize content/text.
switch ( $text_source ) {
	case 'custom_field':
		if ( ! empty( $atts['text_custom_field'] ) ) {
			$text_custom_field = $atts['text_custom_field'];
			if ( str_starts_with( $text_custom_field, 'field_' ) && function_exists( 'get_field' ) ) {
				$content = get_field( $text_custom_field, vcex_get_the_ID() );
			} else {
				$content = get_post_meta( vcex_get_the_ID(), $text_custom_field, true );
			}
		}
		break;
	case 'callback_function':
		if ( $text_callback_function
			&& function_exists( $text_callback_function )
			&& vcex_validate_user_func( $text_callback_function )
		) {
			$content = call_user_func( $text_callback_function );
		}
		break;
}

// Content is required.
if ( empty( $content ) || ! is_string( $content ) ) {
	return;
}

// Output var.
$output = '';

// Get link.
$url = $atts['url'] ?? '';
if ( $link ) {
	$link_url_temp = $link;
	$link_url = vcex_get_link_data( 'url', $link_url_temp );
	if ( $link_url ) {
		$url = $link_url;
		$link_title = $atts['link_title'] ?? '';
		$link_target = $atts['link_target'] ?? '';
	}
}

// Classes & data.
$wrap_attrs = array(
	'id'    => vcex_get_unique_id( $unique_id ),
	'class' => '', // so that class is added before inline style
);

// Wrap classes.
$wrap_class = [
	'vcex-list_item',
	'vcex-module',
	'wpex-m-0', // removes default heading margin.
	'wpex-max-w-100',
	'wpex-clr', // @todo remove
];

if ( $bottom_margin ) {
	$wrap_class[] = vcex_sanitize_margin_class( $bottom_margin, 'wpex-mb-' );
} else {
	$wrap_class[] = 'wpex-mb-5';
}

if ( $css_animation_class = vcex_get_css_animation( $css_animation ) ) {
	$wrap_class[] = $css_animation_class;
}

if ( $visibility ) {
	$wrap_class[] = vcex_parse_visibility_class( $visibility );
}

if ( $css ) {
	$wrap_class[] = vcex_vc_shortcode_custom_css_class( $css );
}

if ( $text_align ) {
	$wrap_class[] = 'text' . sanitize_html_class( $text_align );
}

if ( ! empty( $atts['responsive_text_min_max'] )
	|| ( isset( $atts['responsive_font_size'] ) && 'true' == $atts['responsive_font_size'] )
) {

	$min_max = $atts['responsive_text_min_max'] ?? null;
	if ( $min_max && is_string( $min_max ) ) {
		$min_max = explode( '|', $min_max );
	}
	$font_size = $min_max[1] ?? $font_size ?? null;
	$min_font_size = $min_max[0] ?? $min_font_size ?? null;

	if ( $font_size && $min_font_size ) {

		// Sanitize sizes.
		$font_size = vcex_parse_min_max_text_font_size( $font_size );
		$min_font_size = vcex_parse_min_max_text_font_size( $min_font_size );

		// Add wrap classes and data.
		if ( $font_size && $min_font_size ) {
			$wrap_class[] = 'wpex-responsive-txt';
			$wrap_attrs['data-max-font-size'] = absint( $font_size );
			$wrap_attrs['data-min-font-size'] = absint( $min_font_size );
			wp_enqueue_script( 'vcex-responsive-text' );
			$atts['font_size'] = $font_size;
		}
	}

} else {

	// Responsive styles.
	$unique_classname = vcex_element_unique_classname();

	$el_responsive_styles = array(
		'font_size' => $atts['font_size'],
	);

	$responsive_css = vcex_element_responsive_css( $el_responsive_styles, $unique_classname );

	if ( $responsive_css ) {
		$wrap_class[] = $unique_classname;
		$output .= '<style>' . $responsive_css . '</style>';
	}

}

// Add wrapper styles.
$wrap_attrs['style'] = vcex_inline_style( [
	'font_family'        => $atts['font_family'],
	'font_size'          => $atts['font_size'],
	'color'              => $atts['font_color'],
	'font_weight'        => $atts['font_weight'],
	'font_style'         => $atts['font_style'],
	'line_height'        => $atts['line_height'],
	'background_color'   => $atts['background_color'],
	'border_color'       => $atts['border_color'],
	'animation_delay'    => $atts['animation_delay'],
	'animation_duration' => $atts['animation_duration'],
] );

$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_list_item' );

if ( $extra_classes ) {
	$wrap_class = array_merge( $wrap_class, $extra_classes );
}

// Turn classes into string, apply filters and sanitize.
$wrap_attrs['class'] = esc_attr( vcex_parse_shortcode_classes( $wrap_class, 'vcex_list_item', $atts ) );

$html_tag_safe = ! empty( $atts['tag'] ) ? tag_escape( $atts['tag'] ) : 'div';

// Begin output.
$output .= '<' . $html_tag_safe . vcex_parse_html_attributes( $wrap_attrs ) . '>';

	if ( $url ) {

		$link_attrs = array(
			'href'   => esc_url( do_shortcode( $url ) ),
			'title'  => do_shortcode( vcex_get_link_data( 'title', $link_url_temp, $link_title ) ),
			'target' => vcex_get_link_data( 'target', $link_url_temp, $link_target ),
			'rel'    => vcex_get_link_data( 'rel', $link_url_temp ),
			'class'  => 'vcex-list-item-link wpex-no-underline',
		);

		if ( $font_color ) {
			$link_attrs['class'] .= ' wpex-inherit-color';
		}

		$output .= '<a '. vcex_parse_html_attributes( $link_attrs ) . '>';

	}

	$inner_classes = apply_filters( 'vcex_list_item_inner_class', [
		'vcex-list-item-inner',
		'wpex-inline-flex',
		'wpex-flex-no-wrap',
	] );

	if ( $atts['flex_align'] && 'start' !== $atts['flex_align'] ) {
		$inner_classes[] = 'wpex-items-' . sanitize_html_class( $atts['flex_align'] );
	}

	$output .= '<div class="' . esc_attr( implode( ' ', $inner_classes ) ) . '">';

		if ( $icon || $icon_alternative_classes ) {

			$icon_classes = [
				'vcex-list-item-icon',
			];

			if ( $icon_spacing ) {
				$icon_classes[] = 'wpex-mr-' . sanitize_html_class( absint( $icon_spacing ) );
			} else {
				$icon_classes[] = 'wpex-mr-10';
			}

			$icon_style = vcex_inline_style( [
				'margin_right' => $atts['margin_right'] ?? null,
			] );

			// List item icon.
			$output .= '<div class="' . esc_attr( implode( ' ', $icon_classes ) ) . '"' . $icon_style . '>';

				// List item icon wrap.
				if ( ! $icon_height && $icon_size ) {
					$icon_height = $icon_size;
				}

				$style_args = array(
					'background'    => $atts['icon_background'],
					'width'         => $atts['icon_width'],
					'border_radius' => $atts['icon_border_radius'],
					'height'        => $atts['icon_height'],
					'icon_size'     => $atts['icon_size'],
					'color'         => $atts['color'],
				);

				$output .= '<div class="vcex-icon-wrap wpex-inline-flex wpex-justify-center wpex-items-center"' . vcex_inline_style( $style_args ) . '>';

				if ( $icon_alternative_classes ) {

					$output .= '<span class="' . esc_attr( do_shortcode( $icon_alternative_classes ) ) . '"></span>';

				} else {

					$icon_html = vcex_get_icon_html( $atts, 'icon' );

					if ( $icon_html ) {
						$output .= $icon_html;
					}

				}

				$output .= '</div>';

			$output .= '</div>';

		}

		$output .= '<div class="vcex-list-item-text vcex-content wpex-flex-grow">';

			$output .= vcex_parse_text_safe( $content );

		$output .= '</div>';

	$output .= '</div>';

	if ( $url ) {
		$output .= '</a>';
	}

$output .= '</' . $html_tag_safe . '>';

// @codingStandardsIgnoreLine
echo $output;