<?php
/**
 * vcex_button shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

// Get shortcode attributes.
$atts = vcex_shortcode_atts( 'vcex_button', $atts, 'VCEX_Button_Shortcode' );

// Declare main vars.
$output        = '';
$button_data   = [];
$layout        = $atts['layout'] ?? '';
$align         = ( empty( $atts['text_align'] ) && ! empty( $atts['align'] ) ) ? $atts['align'] : null;
$onclick       = $atts['onclick'] ?? null;
$text_source   = $atts['text_source'] ?? '';
$url           = ! empty( $atts['url'] ) ? $atts['url'] : '#';
$button_style  = $atts['style'] ?? '';
$button_color  = $atts['color'] ?? '';
$button_size   = $atts['size'] ?? '';
$button_align  = $atts['align'] ?? '';
$button_state  = $atts['state'] ?? '';
$lightbox_type = $atts['lightbox_type'] ?? '';

// Gutenberg links.
if ( '{{post}}' === $url ) {
	$onclick = 'post_permalink';
}

// Sanitize content.
switch ( $text_source ) {
	case 'custom_field':
		if ( ! empty( $atts['text_custom_field'] ) ) {
			if ( function_exists( 'get_field' ) && str_starts_with( $atts['text_custom_field'], 'field_' ) ) {
				$content = get_field( $atts['text_custom_field'], vcex_get_the_ID() );
			} else {
				$content = get_post_meta( vcex_get_the_ID(), $atts['text_custom_field'], true );
			}
			if ( ! $content && vcex_is_template_edit_mode() ) {
				$content = vcex_custom_field_placeholder( $atts['text_custom_field'] );
			}
		}
		if ( ! empty( $content ) ) {
			$content = wp_kses_post( $content );
		}
		break;
	case 'callback_function':
		if ( ! empty( $atts['text_callback_function'] ) && vcex_validate_user_func( $atts['text_callback_function'] ) ) {
			$content = call_user_func( $atts['text_callback_function'] );
		}
		break;
	default:
		if ( ! empty( $content ) ) {
			$content = str_replace( '{{post_title}}', get_the_title(), $content );
			$content = wp_kses_post( $content );
		} else {
			$content = esc_html__( 'Button Text', 'total' );
		}
		break;
}

// Don't show button if content is empty.
if ( empty( $content ) || ! is_string( $content ) ) {
	return;
}

// Button Classes.
$button_classes = [
	'vcex-button',
];

$button_classes[] = vcex_get_button_classes( $button_style, $button_color, $button_size, $button_align );

if ( $button_state ) {
	$button_classes[] = sanitize_html_class( $atts['state'] );
}

if ( ! empty( $atts['bottom_margin'] ) ) {
	$button_classes[] = vcex_sanitize_margin_class( $atts['bottom_margin'], 'wpex-mb-' );
}

if ( ! empty( $atts['layout'] ) ) {
	$button_classes[] = $atts['layout'];
}

if ( ! empty( $atts['classes'] ) ) {
	$button_classes[] = vcex_get_extra_class( $atts['classes'] );
}

if ( ! empty( $atts['hover_animation'] ) ) {
	$button_classes[] = vcex_hover_animation_class( $atts['hover_animation'] );
	vcex_enque_style( 'hover-animations' );
}

if ( ! empty( $atts['css_animation'] ) && 'none' !== $atts['css_animation'] && empty( $atts['css_wrap'] ) ) {
	$button_classes[] = vcex_get_css_animation( $atts['css_animation'] );
}

if ( ! empty( $atts['shadow'] ) ) {
	$button_classes[] = vcex_parse_shadow_class( $atts['shadow'] );
}

if ( ! empty( $atts['width'] ) ) {
	$button_classes[] = 'wpex-flex-shrink-0';
}

if ( ! empty( $atts['visibility'] ) ) {
	$button_classes[] = vcex_parse_visibility_class( $atts['visibility'] );
}

// Do things based on the selected onclick action.
switch ( $onclick ) {
	case 'local_scroll':
		$button_classes[] = 'local-scroll-link';
		break;
	case 'go_back':
		$url = '#';
		$button_classes[] = 'wpex-go-back';
		break;
	case 'toggle_element':
		$button_classes[] = 'wpex-toggle-element-trigger';
		break;
	case 'post_permalink':
		$url = get_permalink( vcex_get_the_ID() );
		break;
	case 'internal_link':
		if ( ! empty( $atts['internal_link'] ) ) {
			$internal_link = vcex_build_link( $atts['internal_link'] );
		}
		$url = ! empty( $internal_link['url'] ) ? $internal_link[ 'url' ] : '#';
		break;
	case 'custom_field':
		if ( ! empty( $atts['url_custom_field'] ) && is_string( $atts['url_custom_field'] ) ) {
			if ( function_exists( 'get_field' ) && str_starts_with( $atts['url_custom_field'], 'field_' ) ) {
				$url = get_field( $atts['url_custom_field'], vcex_get_the_ID() );
			} else {
				$url = get_post_meta( vcex_get_the_ID(), $atts['url_custom_field'], true );
			}
			if ( ! empty( $url ) && is_array( $url ) ) {
				$url = $url['url'] ?? '';
			}
			if ( ! $url && vcex_is_template_edit_mode() ) {
				$url = '#';
			}
		}
		if ( empty( $url ) || ! is_string( $url ) ) {
			return; // Lets not show any button if the custom field is empty
		}
		break;
	case 'callback_function':
		if ( ! empty( $atts['url_callback_function'] ) && vcex_validate_user_func( $atts['url_callback_function'] ) ) {
			$url = call_user_func( $atts['url_callback_function'] );
			if ( ! $url ) {
				return; // Lets not show any button if the callback is empty
			}
		}
		break;
	case 'image':
	case 'lightbox':
		if ( ! empty( $atts['image_attachment'] ) ) {
			$image_attachment = $atts['image_attachment']['id'] ?? $atts['image_attachment'];
			$url = wp_get_attachment_url( $image_attachment );
		}
		// Enqueue lightbox scripts
		vcex_enqueue_lightbox_scripts();

		// Lightbox gallery.
		$lightbox_gallery = $atts['lightbox_gallery'] ?? [];

		if ( vcex_validate_att_boolean( 'lightbox_post_gallery', $atts ) ) {
			$gallery_ids = vcex_get_post_gallery_ids();
			if ( $gallery_ids ) {
				$lightbox_gallery = $gallery_ids;
			}
		}

		if ( $lightbox_gallery ) {
			$button_classes[] = 'wpex-lightbox-gallery';
			if ( is_string( $lightbox_gallery ) ) {
				$gallery_ids = explode( ',', $lightbox_gallery );
			} elseif ( is_array( $lightbox_gallery ) ) {
				foreach ( $lightbox_gallery as $lb_gallery_img ) {
					$gallery_ids[] = $lb_gallery_img['id'] ?? $lb_gallery_img['attachment'] ?? $lb_gallery_img;
				}
			}
			if ( $gallery_ids && is_array( $gallery_ids ) ) {
				$button_data[] = 'data-gallery="' . vcex_parse_inline_lightbox_gallery( $gallery_ids ) . '"';
			}
		}

		// Iframe lightbox.
		switch ( $lightbox_type ) {
			case 'inline':
				$safe_url = esc_attr( $url );
				$button_classes[] = 'wpex-lightbox';
				$button_data[] = 'data-src="' . $safe_url . '"'; // prevents page jump.
				$button_data[] = 'aria-controls="' . str_replace( '#', '', $safe_url ) . '"';
				$url = ''; // must be empty!
				break;
			case 'iframe':
				$button_classes[] = 'wpex-lightbox';
				$button_data[]    = 'data-type="iframe"';
				break;
			case 'image':
				$button_classes[] = 'wpex-lightbox';
				if ( ! empty( $atts['image_attachment'] ) ) {
					$image_attachment = $atts['image_attachment']['id'] ?? $atts['image_attachment'];
					$url = wp_get_attachment_url( $image_attachment );
				}
				break;
			case 'video_embed':
				$url = do_shortcode( wp_kses_post( $url ) );
				if ( $url ) {
					$url = vcex_get_video_embed_url( $url );
				}
				$button_classes[] = 'wpex-lightbox';
				break;
			case 'html5':
				$button_classes[] = 'wpex-lightbox';
				if ( ! empty( $atts['lightbox_video_html5_webm'] ) ) {
					$url = $atts['lightbox_video_html5_webm'];
				}
				break;
			default:
				if ( $url ) {
					$button_classes[] = 'wpex-lightbox';
				}
				break;
		}

		// Disable title.
		if ( ! vcex_validate_att_boolean( 'lightbox_title', $atts, 'true' ) ) {
			$button_data[] = 'data-show_title="false"';
		}

		// Add lightbox dimensions.
		if ( in_array( $lightbox_type, [ 'video', 'video_embed', 'url', 'html5', 'iframe', 'inline' ] ) ) {
			$lightbox_dimensions = $atts['lightbox_dimensions'] ?? '';
			$lightbox_dims = vcex_parse_lightbox_dims( $lightbox_dimensions, 'array' );
			if ( $lightbox_dims ) {
				$button_data[] = 'data-width="' . esc_attr( $lightbox_dims['width'] ) . '"';
				$button_data[] = 'data-height="' . esc_attr( $lightbox_dims['height'] ) . '"';
			}
		}
		break;
}

// Custom data attributes.
if ( ! empty( $atts['data_attributes'] ) ) {
	$data_attributes = explode( ',', $atts['data_attributes'] );
	if ( is_array( $data_attributes ) ) {
		foreach( $data_attributes as $attribute ) {
			if ( false !== strpos( $attribute, '|' ) ) {
				$attribute = explode( '|', $attribute );
				$button_data[] = 'data-' . esc_attr( $attribute[0] ) .'="' . esc_attr( do_shortcode( $attribute[1] ) ) . '"';
			} else {
				$button_data[] = 'data-' . esc_attr( $attribute );
			}
		}
	}
}

// Wrap classes.
$wrap_classes = [];

if ( 'center' === $align ) {
	$wrap_classes[] = 'textcenter'; // @todo update to use wpex-text-center
} elseif ( ! empty( $atts['text_align'] ) ) {
	$wrap_classes[] = 'wpex-text-' . sanitize_html_class( $atts['text_align'] );
}

switch ( $layout ) {
	case 'block':
		$wrap_classes[] = 'theme-button-block-wrap';
		$wrap_classes[] = 'wpex-block';
		$wrap_classes[] = 'wpex-clear';
		break;
	case 'expanded':
		$wrap_classes[]   = 'theme-button-expanded-wrap';
		$button_classes[] = 'expanded';
		break;
}

if ( $wrap_classes ) {
	array_unshift( $wrap_classes, 'theme-button-wrap' );
	if ( $align ) {
		$wrap_classes[] = 'wpex-clr';
	}
	$wrap_classes = implode( ' ', $wrap_classes );
}

$wrap_classes = vcex_parse_shortcode_classes( $wrap_classes, 'vcex_button', $atts );

// Custom Style.
$inline_style = vcex_inline_style( [
	'background'         => $atts['custom_background'] ?? null,
	'padding'            => $atts['font_padding'] ?? null,
	'color'              => $atts['custom_color'] ?? null,
	'border'             => $atts['border'] ?? null,
	'font_size'          => $atts['font_size'] ?? null,
	'font_weight'        => $atts['font_weight'] ?? null,
	'letter_spacing'     => $atts['letter_spacing'] ?? null,
	'border_radius'      => $atts['border_radius'] ?? null,
	'margin'             => $atts['margin'] ?? null,
	'width'              => $atts['width'] ?? null,
	'text_transform'     => $atts['text_transform'] ?? null,
	'font_family'        => $atts['font_family'] ?? null,
	'animation_delay'    => $atts['animation_delay'] ?? null,
	'animation_duration' => $atts['animation_duration'] ?? null,
], false );

if ( $inline_style ) {
	$inline_style = ' style="' . esc_attr( $inline_style ) . '"';
}

// Custom hovers.
$hover_data = [];
if ( ! empty( $atts['custom_hover_background'] ) ) {
	$hover_data['background'] = esc_attr( vcex_parse_color( $atts['custom_hover_background'] ) );
}
if ( ! empty( $atts['custom_hover_color'] ) ) {
	$hover_data['color'] = esc_attr( vcex_parse_color( $atts['custom_hover_color'] ) );
}
if ( $hover_data ) {
	$button_data[] = "data-wpex-hover='" . htmlspecialchars( wp_json_encode( $hover_data ) ) . "'";
}

// Define button icon_classes.
$icon_left  = vcex_get_icon_html( $atts, 'icon_left' );
$icon_right = vcex_get_icon_html( $atts, 'icon_right' );

// Icon right style.
if ( $icon_right ) {
	$icon_right_style = vcex_inline_style ( [
		'padding_left' => $atts['icon_right_padding'] ?? '',
	] );
}

// Responsive styles.
$unique_classname = vcex_element_unique_classname();

$el_responsive_styles = [
	'font_size' => $atts['font_size'],
];

$responsive_css = vcex_element_responsive_css( $el_responsive_styles, $unique_classname );

if ( $responsive_css ) {
	$button_classes[] = $unique_classname;
	$output .= '<style>' . $responsive_css . '</style>';
}

// Turn arrays into strings.
$button_classes = implode( ' ', $button_classes );
$button_data    = implode( ' ', $button_data );

// Open CSS wrapper.
if ( ! empty( $atts['css_wrap'] ) ) {
	$css_wrap_class = vcex_vc_shortcode_custom_css_class( $atts['css_wrap'] );
	$css_wrap_style_args = [];

	if ( ! empty( $atts['css_animation'] ) && 'none' !== $atts['css_animation'] ) {
		if ( ! empty( $atts['animation_delay'] ) ) {
			$css_wrap_style_args[ 'animation_delay' ] = $atts['animation_delay'];
		}
		if ( ! empty( $atts['animation_duration'] ) ) {
			$css_wrap_style_args[ 'animation_duration' ] = $atts['animation_duration'];
		}
		$css_wrap_class .= ' ' . vcex_get_css_animation( $atts['css_animation'] );
	}

	$css_wrap_style = vcex_inline_style( $css_wrap_style_args );

	$output .= '<div class="' . esc_attr( $css_wrap_class ) . ' wpex-clr"' . $css_wrap_style . '>';

}

	// Open wrapper for specific button styles.
	if ( $wrap_classes ) {
		$output .= '<div class="' . esc_attr( $wrap_classes ) . '">';
	}

		$href = do_shortcode( $url );

		$link_attrs = [
			'id'       => vcex_get_unique_id( $atts ),
			'href'     => esc_url( $href ),
			'title'    => ! empty( $atts['title'] ) ? esc_attr( do_shortcode( $atts['title'] ) ) : '',
			'class'    => esc_attr( $button_classes ),
			'target'   => $atts['target'] ?? '',
			'style'    => $inline_style,
			'rel'      => $atts['rel'] ?? '',
			'data'     => $button_data,
		];

		if ( ! empty( $atts['aria_label'] ) ) {
			$link_attrs['aria-label'] = esc_attr( trim( $atts['aria_label'] ) );
		}

		if ( vcex_validate_att_boolean( 'download_attribute', $atts, false ) ) {
			$link_attrs['download'] = 'download';
		}

		if ( 'toggle_element' === $onclick ) {
			$link_attrs['aria-expanded'] = ( 'active' === $button_state ) ? 'true' : 'false';
			$link_attrs['aria-controls'] = str_replace( '#', '', $href );
			if ( ! empty( $atts['toggle_element_active_text'] ) ) {
				$link_attrs['data-open-text'] = wp_strip_all_tags( vcex_parse_text( $content ) );
				$active_text = wp_strip_all_tags( vcex_parse_text( $atts['toggle_element_active_text'] ) );
				$content = $active_text;
				$link_attrs['data-close-text'] = $active_text;
			}
		}

		// Open Link.
		$output .= '<a' . vcex_parse_html_attributes( $link_attrs ) . '>';

			// Open inner span.
			$output .= '<span class="theme-button-inner">';

				// Left Icon.
				if ( $icon_left ) {

					$icon_left_style = vcex_inline_style ( [
						'padding_right' => $atts['icon_left_padding'] ?? null,
					] );

					$attrs = [
						'class' => [
							'vcex-icon-wrap',
							'theme-button-icon-left',
						],
						'style' => $icon_left_style,
					];

					if ( ! empty( $atts['icon_left_transform'] ) ) {
						$attrs['class'][] = 'wpex-transition-transform wpex-duration-200';
						$attrs['data-wpex-hover'] = htmlspecialchars( wp_json_encode( [
							'parent'    => '.vcex-button',
							'transform' => 'translateX(' . vcex_validate_font_size( $atts['icon_left_transform'] ) . ')',
						] ) );
					}

					$output .= '<span' . vcex_parse_html_attributes( $attrs ) . '>';

						$output .= $icon_left;

					$output .= '</span>';

				}

				// Text.
				if ( 'toggle_element' === $onclick && 'toggle_element' === $onclick ) {
					$output .= '<span class="theme-button-text">' . vcex_parse_text( $content ) . '</span>';
				} else {
					$output .= vcex_parse_text( $content );
				}

				// Icon Right.
				if ( $icon_right ) {

					$attrs = [
						'class' => [
							'vcex-icon-wrap',
							'theme-button-icon-right',
						],
						'style' => $icon_right_style,
					];

					if ( ! empty( $atts['icon_right_transform'] ) ) {
						$attrs['class'][] = 'wpex-transition-transform wpex-duration-200';
						$attrs['data-wpex-hover'] = htmlspecialchars( wp_json_encode( [
							'parent'    => '.vcex-button',
							'transform' => 'translateX(' . vcex_validate_font_size( $atts['icon_right_transform'] ) . ')',
						] ) );
					}

					$output .= '<span' . vcex_parse_html_attributes( $attrs ) . '>';

						$output .= $icon_right;

					$output .= '</span>';

				}

			// Close inner span.
			$output .= '</span>';

		// Close link.
		$output .= '</a>';

	// Close wrapper for specific button styles.
	if ( $wrap_classes ) {
		$output .=  '</div>';
	}

// Close css wrap div.
if ( ! empty( $atts['css_wrap'] ) ) {
	$output .= '</div>';
}

// @codingStandardsIgnoreLine
echo $output . ' ';