<?php
/**
 * vcex_bullets shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

// Return if no content.
if ( empty( $content ) ) {
	return;
}

// Escape content early to prevent issues with RGBA colors not working with wp_kses_post.
$content_escaped = wp_kses_post( $content );

// Define output.
$output = '';

// Get shortcode attributes.
$atts = vcex_shortcode_atts( 'vcex_bullets', $atts, 'VCEX_Bullets_Shortcode' );

// Check if icon is enabled.
$has_icon = isset( $atts['has_icon'] ) && 'true' == $atts['has_icon'] ? true : false;

// Define wrap attributes.
$shortcode_attrs = [
	'id'   => vcex_get_unique_id( $atts['unique_id'] ),
	'data' => '',
];

// Wrap classes.
$shortcode_class = [
	'vcex-module',
	'vcex-bullets',
];

if ( 'horizontal' === $atts['alignment'] ) {
	$shortcode_class[] = 'vcex-bullets--horizontal';
	if ( ! empty( $atts['gap'] ) ) {
		$shortcode_class[] = 'wpex-gap-' . sanitize_html_class( absint( $atts['gap'] ) );
	} else {
		$shortcode_class[] = 'wpex-gap-20';
	}
	if ( $justify = vcex_parse_justify_content_class( $atts['justify'] ) ) {
		$shortcode_class[] = $justify;
	}
}

if ( $has_icon ) {

	// Pre-defined bullet styles.
	if ( $atts['style'] && ! $atts['icon_type'] ) {
		$shortcode_class[] = 'vcex-bullets-' . sanitize_html_class( $atts['style'] );
	}

	// Custom Icon.
	else {

		// Generate icon styles.
		$icon_style = vcex_inline_style( [
			'color' => $atts['icon_color'] ?? null
		], false );

		// Get icon html.
		$icon_html = vcex_get_icon_html( $atts, 'icon', [
			'class' => 'vcex-icon',
			'style' => $icon_style,
		] );

		// Show Icon.
		if ( $icon_html ) {

			// Icon HTML.
			if ( ! empty( $atts['icon_spacing'] ) ) {
				$icon_spacing = 'wpex-mr-' . sanitize_html_class( absint( $atts['icon_spacing'] ) );
			} else {
				$icon_spacing = 'wpex-mr-10';
			}

			$add_icon = '<div class="vcex-bullets-ci-wrap wpex-inline-flex"><span class="vcex-icon-wrap ' . $icon_spacing . '">' . $icon_html . '</span><div class="vcex-content wpex-flex-grow">';

			// Standard bullets search/replace.
			$content = $content_escaped;
			$content = str_replace( '<li>', '<li>' . $add_icon, $content );

			// Fix bugs with inline center align (lots of customers centered the bullets before align option was added).
			$content = str_replace( '<li style="text-align:center">', '<li style="text-align:center;">', $content );
			$content = str_replace( '<li style="text-align: center">', '<li style="text-align:center;">', $content );
			$content = str_replace( '<li style="text-align: center;">', '<li style="text-align:center;">', $content );
			$content = str_replace( '<li style="text-align:center;">', '<li style="text-align:center;">' . $add_icon, $content );

			// Close elements.
			$content = str_replace( '</li>', '</div></div></li>', $content );
			$content_escaped = $content;

			// Add custom icon wrap class.
			$shortcode_class[] = 'custom-icon';

		}

	}

} else {
	$shortcode_class[] = 'vcex-bullets-ni';
}

// Wrap Style.
$shortcode_attrs['style'] = vcex_inline_style( [
	'background_color'   => $atts['background_color'] ?? null,
	'border_color'       => $atts['border_color'] ?? null,
	'color'              => $atts['color'] ?? null,
	'font_family'        => $atts['font_family'] ?? null,
	'font_size'          => $atts['font_size'] ?? null,
	'letter_spacing'     => $atts['letter_spacing'] ?? null,
	'font_weight'        => $atts['font_weight'] ?? null,
	'line_height'        => $atts['line_height'] ?? null,
	'text_transform'     => $atts['text_transform'] ?? null,
	'animation_delay'    => $atts['animation_delay'] ?? null,
	'animation_duration' => $atts['animation_duration'] ?? null,
] );

// Responsive styles.
$unique_classname = vcex_element_unique_classname();

$el_responsive_styles = [
	'font_size' => $atts['font_size'],
];

$responsive_css = vcex_element_responsive_css( $el_responsive_styles, $unique_classname );

if ( $responsive_css ) {
	$shortcode_class[] = $unique_classname;
	$output .= '<style>' . $responsive_css . '</style>';
}

// Get extra classes.
$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_bullets' );

if ( $extra_classes ) {
	$shortcode_class = array_merge( $shortcode_class, $extra_classes );
}

// Turn shortcode classes array into string.
$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_bullets', $atts );

// Add filters to shortcode classes and add to attributes.
$shortcode_attrs['class'] = esc_attr( $shortcode_class );

// Begin html output.
$output .= '<div' . vcex_parse_html_attributes( $shortcode_attrs ) . '>';

	$output .= vcex_parse_text( $content_escaped );

$output .= '</div>';

// @codingStandardsIgnoreLine
echo $output;