<?php
defined( 'ABSPATH' ) || exit;

use TotalThemeCore\Vcex\Post_Cards;
use TotalThemeCore\Cards\Builder as Card_Builder;

/**
 * Post Cards Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
if ( ! class_exists( 'Wpex_Post_Cards_Shortcode' ) ) {

	class Wpex_Post_Cards_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'wpex_post_cards';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Post_Cards;
			}
		}

		/**
		 * Shortcode output function.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! is_array( $atts ) ) {
				return; // this element can't render without settings.
			}
			$post_cards = new Post_Cards( $atts );
			return $post_cards->get_output();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$custom_card_link = '';

			if ( post_type_exists( Card_Builder::POST_TYPE ) ) {
				$custom_card_link = ' | ' . sprintf( esc_html__( '%sCreate Card%s', 'total-theme-core' ), '<a href="' . esc_url( admin_url( 'edit.php?post_type=' . Card_Builder::POST_TYPE ) ) . '" target="_blank" rel="noopener noreferrer">', '</a>' );
			}

			$params = array(
				// General
				array(
					'type' => 'vcex_wpex_card_select',
					'heading' => esc_html__( 'Card Style', 'total-theme-core' ),
					'param_name' => 'card_style',
					'description' => esc_html__( 'Select your card style. Note: Not all settings are used for every card style', 'total-theme-core' ) . '<br>' . sprintf( esc_html__( '%sPreview card styles%s', 'total-theme-core' ), '<a href="https://total.wpexplorer.com/features/cards/" target="_blank" rel="noopener noreferrer">', '</a>' ) . $custom_card_link,
					'admin_label' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin',
					'value' => vcex_margin_choices(),
					'admin_label' => true,
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Display Type', 'total-theme-core' ),
					'param_name' => 'display_type',
					'value' => array(
						esc_html__( 'Grid', 'total-theme-core' ) => 'grid',
						esc_html__( 'Flex Items / Horizontal Scroll', 'total-theme-core' ) => 'flex',
						esc_html__( 'List', 'total-theme-core' ) => 'list',
						esc_html__( 'Carousel', 'total-theme-core' ) => 'carousel',
					),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Flex Basis', 'total-theme-core' ),
					'param_name' => 'flex_basis',
					'choices' => [
						'' => esc_html__( 'Auto', 'total-theme-core' ),
						'1' => esc_html__( '1 Column', 'total-theme-core' ),
						'2' => esc_html__( '2 Columns', 'total-theme-core' ),
						'3' => esc_html__( '3 Columns', 'total-theme-core' ),
						'4' => esc_html__( '4 Columns', 'total-theme-core' ),
					],
					'description' => esc_html__( 'Set the initial size (width) for your entries.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'display_type', 'value' => 'flex' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Scroll Snap Type', 'total-theme-core' ),
					'param_name' => 'flex_scroll_snap_type',
					'choices' => [
						'proximity' => esc_html__( 'Proximity', 'total-theme-core' ),
						'mandatory' => esc_html__( 'Mandatory', 'total-theme-core' ),
						'none' => esc_html__( 'None', 'total-theme-core' ),
					],
					'description' => esc_html__( 'Sets how strictly snap points are enforced on the scroll container in case there is one.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'display_type', 'value' => 'flex' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Flex Breakpoint', 'total-theme-core' ),
					'param_name' => 'flex_breakpoint',
					'value' => self::get_media_breakpoint_choices( false ),
					'description' => esc_html__( 'The breakpoint at which the entries will stack vertically. By default the flex container will create a horizontal scroll bar instead of stacking.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'display_type', 'value' => 'flex' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Hide Scrollbar', 'total-theme-core' ),
					'param_name' => 'hide_scrollbar',
					'dependency' => array( 'element' => 'display_type', 'value' => 'flex' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Grid Style', 'total-theme-core' ),
					'param_name' => 'grid_style',
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => 'fit_rows',
						esc_html__( 'Masonry', 'total-theme-core' ) => 'masonry',
						esc_html__( 'Modern CSS Grid', 'total-theme-core' ) => 'css_grid',
					),
					'edit_field_class' => 'vc_col-sm-4 vc_column clear',
					'dependency' => array( 'element' => 'display_type', 'value' => array( 'grid', 'masonry_grid' ) ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_grid_columns',
					'heading' => esc_html__( 'Columns', 'total-theme-core' ),
					'param_name' => 'grid_columns',
					'std' => '3',
					'edit_field_class' => 'vc_col-sm-4 vc_column',
					'dependency' => array( 'element' => 'display_type', 'value' => array( 'grid', 'masonry_grid' ) ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Responsive', 'total-theme-core' ),
					'param_name' => 'grid_columns_responsive',
					'value' => array(
						esc_html__( 'Yes', 'total-theme-core' ) => 'true',
						esc_html__( 'No', 'total-theme-core' ) => 'false',
					),
					'edit_field_class' => 'vc_col-sm-4 vc_column',
					'dependency' => array( 'element' => 'grid_columns', 'value' => array( '2', '3', '4', '5', '6', '7', '8', '9', '10' ) ),
				),
				array(
					'type' => 'vcex_grid_columns_responsive',
					'heading' => esc_html__( 'Responsive Column Settings', 'total-theme-core' ),
					'param_name' => 'grid_columns_responsive_settings',
					'dependency' => array( 'element' => 'grid_columns_responsive', 'value' => 'true' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Column Gap', 'total-theme-core' ),
					'param_name' => 'grid_spacing',
					'choices' => 'gap',
					'dependency' => array(
						'element' => 'display_type',
						'value' => array( 'grid', 'masonry_grid', 'flex' ),
					),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'List Spacing', 'total-theme-core' ),
					'param_name' => 'list_spacing',
					'css' => [
						'property' => 'gap',
						'selector' => '.wpex-post-cards-list',
					],
					'choices' => 'gap',
					'dependency' => array( 'element' => 'display_type', 'value' => 'list' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'List Divider', 'total-theme-core' ),
					'param_name' => 'list_divider',
					'value' => array(
						esc_html__( 'None', 'total-theme-core' ) => '',
						esc_html__( 'Solid', 'total-theme-core' ) => 'solid',
						esc_html__( 'Dashed', 'total-theme-core' ) => 'dashed',
						esc_html__( 'Dotted', 'total-theme-core' ) => 'dotted',
					),
					'dependency' => array( 'element' => 'display_type', 'value' => 'list' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'List Divider Size', 'total-theme-core' ),
					'param_name' => 'list_divider_size',
					'dependency' => array( 'element' => 'list_divider', 'not_empty' => true ),
					'value' => vcex_border_width_choices(),
					'elementor' => [
						'condition' => [
							'display_type' => 'list',
							'list_divider!' => '',
						],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'List Divider Color', 'total-theme-core' ),
					'param_name' => 'list_divider_color',
					'dependency' => array( 'element' => 'list_divider', 'not_empty' => true ),
					'css' => [
						'property' => 'border-color',
						'selector' => '.wpex-card-list-divider',
					],
					'elementor' => [
						'condition' => [
							'display_type' => 'list',
							'list_divider!' => '',
						],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Remove Divider Before First Entry?', 'total-theme-core' ),
					'param_name' => 'list_divider_remove_first',
					'std' => 'true',
					'dependency' => array( 'element' => 'list_divider', 'not_empty' => true ),
					'elementor' => [
						'condition' => [
							'display_type' => 'list',
							'list_divider!' => '',
						],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Remove Divider After Last Entry?', 'total-theme-core' ),
					'param_name' => 'list_divider_remove_last',
					'std' => 'false',
					'dependency' => array( 'element' => 'list_divider', 'not_empty' => true ),
					'elementor' => [
						'condition' => [
							'display_type' => 'list',
							'list_divider!' => '',
						],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// General
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Alternate Thumbnail Position', 'total-theme-core' ),
					'param_name' => 'alternate_flex_direction',
					'description' => esc_html__( 'Enable to alternate the position of your thumbnail when using certain cards styles. For example if you are using a card style with a left thumbnail every other item will display the thumbnail on the right.', 'total-theme-core' ),
					'std' => 'false',
					'dependency' => array( 'element' => 'display_type', 'value' => 'list' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Element ID', 'total-theme-core' ),
					'param_name' => 'unique_id',
					'admin_label' => true,
					'description' => vcex_shortcode_param_description( 'unique_id' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'el_class',
					'admin_label' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				vcex_vc_map_add_css_animation(),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Sequential Animation', 'total-theme-core' ),
					'param_name' => 'css_animation_sequential',
				),
				// Query
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Query Type', 'total-theme-core' ),
					'param_name' => 'query_type',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'choices' => apply_filters( 'wpex_post_cards_query_type_choices', [
						'' => esc_html__( 'Default', 'total-theme-core' ),
						'auto' => esc_html__( 'Auto (dynamic templates)', 'total-theme-core' ),
						'custom' => esc_html__( 'Advanced (custom arguments)', 'total-theme-core' ),
						'callback' => esc_html__( 'Callback (child theme function)', 'total-theme-core' ),
						'post_gallery' => esc_html__( 'Post Gallery', 'total-theme-core' ),
						'attachments' => esc_html__( 'Custom Gallery', 'total-theme-core' ),
					] ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Callback', 'total' ),
					'param_name' => 'query_callback',
					'choices' => 'callback_functions',
					'description' => sprintf( esc_html__( 'Callback functions must be %swhitelisted%s for security reasons.', 'total' ), '<a href="https://total.wpexplorer.com/docs/how-to-whitelist-callback-functions-for-elements/" target="_blank" rel="noopener noreferrer">', '</a>' ),
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'value' => 'callback' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_attach_images',
					'heading' => esc_html__( 'Images', 'total-theme-core' ),
					'param_name' => 'attachments',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'value' => 'attachments' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'std' => 'post',
					'heading' => esc_html__( 'Automatic Query Preview Post Type', 'total-theme-core' ),
					'param_name' => 'auto_query_preview_pt',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'description' => esc_html__( 'Enter a post type name to use as the placeholder for the preview while editing in the WPBakery live editor.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'value' => 'auto' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textarea_safe',
					'heading' => esc_html__( 'Query Parameter String or Callback Function Name', 'total-theme-core' ),
					'param_name' => 'custom_query_args',
					'description' => vcex_shortcode_param_description( 'advanced_query' ),
					'value' => 'posts_per_page=12&post_type=post&orderby=date',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'value' => 'custom' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'posttypes',
					'heading' => esc_html__( 'Post types', 'total-theme-core' ),
					'param_name' => 'post_types',
					'std' => 'post',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'admin_label' => true,
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Posts Per Page', 'total-theme-core' ),
					'param_name' => 'posts_per_page',
					'value' => '12',
					'description' => esc_html__( 'You can enter "-1" to display all posts.', 'total-theme-core' ),
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array(
						'element' => 'query_type',
						'value' => [ '', 'post_gallery', 'attachments' ]
					),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Pagination', 'total-theme-core' ),
					'param_name' => 'pagination',
					'value' => array(
						esc_html__( 'Disabled', 'total-theme-core' ) => '',
						esc_html__( 'Numbered', 'total-theme-core' ) => 'numbered',
						esc_html__( 'Numbered (Ajaxed)', 'total-theme-core' ) => 'numbered_ajax',
						esc_html__( 'Load More', 'total-theme-core' ) => 'loadmore',
						esc_html__( 'Infinite Scroll', 'total-theme-core' ) => 'infinite_scroll',
					),
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'description' => esc_html__( 'By default pagination is disabled unless using an Auto Query in which case it will used the numbered pagination by default.', 'total-theme-core' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Offset', 'total-theme-core' ),
					'param_name' => 'offset',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'description' => esc_html__( 'Number of post to displace or pass over.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'elementor' => [
						'condition' => [
							'query_type' => '',
							'posts_in' => '',
						],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Query Specific Posts', 'total-theme-core' ),
					'param_name' => 'posts_in',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'settings' => array(
						'multiple' => true,
						'min_length' => 1,
						'groups' => false,
						'unique_values' => true,
						'display_inline' => true,
						'delay' => 0,
						'auto_focus' => true,
					),
					'description' => esc_html__( 'Start typing a post name to locate and add it. Make sure you have selected the Post Types above so they match the post types of the selected posts.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'elementor' => [
						'type' => 'text',
						'description' => esc_html__( 'Enter a comma separated list of post ID\'s to include.', 'total-theme-core' ),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Limit By Author', 'total-theme-core' ),
					'param_name' => 'author_in',
					'settings' => array(
						'multiple' => true,
						'min_length' => 1,
						'groups' => false,
						'unique_values' => true,
						'display_inline' => true,
						'delay' => 0,
						'auto_focus' => true,
					),
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'elementor' => [
						'type' => 'text',
						'description' => esc_html__( 'Enter a comma separated list of author ID\'s to include.', 'total-theme-core' ),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Include Terms', 'total-theme-core' ),
					'param_name' => 'terms_in',
					'admin_label' => true,
					'settings' => array(
						'multiple' => true,
						'min_length' => 1,
						'groups' => true,
						'display_inline' => true,
						'delay' => 0,
						'auto_focus' => true,
					),
					'description' => esc_html__( 'Search for terms (categories, tags or custom taxonomies) you wish to include in the query.', 'total-theme-core' ),
					'elementor' => [
						'type' => 'text',
						'label_block' => true,
						'description' => esc_html__( 'Enter a comma separated list of taxonomy term ids.', 'total-theme-core' ),
					],
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Exclude Terms', 'total-theme-core' ),
					'param_name' => 'terms_not_in',
					'admin_label' => true,
					'settings' => array(
						'multiple' => true,
						'min_length' => 1,
						'groups' => true,
						'display_inline' => true,
						'delay' => 0,
						'auto_focus' => true,
					),
					'description' => esc_html__( 'Search for terms (categories, tags or custom taxonomies) you wish to exclude from the query.', 'total-theme-core' ),
					'elementor' => [
						'type' => 'text',
						'label_block' => true,
						'description' => esc_html__( 'Enter a comma separated list of taxonomy term ids.', 'total-theme-core' ),
					],
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Sticky Posts Only', 'total-theme-core' ),
					'param_name' => 'show_sticky_posts',
					'std' => 'false',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Ignore Sticky Posts', 'total-theme-core' ),
					'param_name' => 'ignore_sticky_posts',
					'std' => 'false',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'description' => esc_html__( 'Include sticky posts, but not at the top.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Exclude Sticky Posts', 'total-theme-core' ),
					'param_name' => 'exclude_sticky_posts',
					'std' => 'false',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Post With Thumbnails Only', 'total-theme-core' ),
					'param_name' => 'thumbnail_query',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Order', 'total-theme-core' ),
					'param_name' => 'order',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => 'default',
						esc_html__( 'DESC', 'total-theme-core' ) => 'DESC',
						esc_html__( 'ASC', 'total-theme-core' ) => 'ASC',
					),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Order By', 'total-theme-core' ),
					'param_name' => 'orderby',
					'value' => vcex_orderby_array(),
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'query_type', 'is_empty' => true ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Orderby: Meta Key', 'total-theme-core' ),
					'param_name' => 'orderby_meta_key',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'dependency' => array( 'element' => 'orderby', 'value' => [ 'meta_value_num', 'meta_value' ] ),
					'elementor' => [
						'condition' => [
							'query_type' => '',
							'orderby' => [ 'meta_value_num', 'meta_value' ],
						],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textarea',
					'heading' => esc_html__( 'No Posts Found Message', 'total-theme-core' ),
					'param_name' => 'no_posts_found_message',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'description' => esc_html__( 'Leave empty to disable.', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Pagination
				array(
					'type' => 'vcex_notice',
					'param_name' => 'pagination_notice',
					'text' => esc_html__( 'Note: The pagination can be globally and further modified via the Customizer.', 'total-theme-core' ),
					'dependency' => [ 'element' => 'pagination', 'value' => [ 'numbered', 'numbered_ajax', 'loadmore', 'infinite_scroll' ] ],
					'group' => esc_html__( 'Pagination', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Top Margin', 'total-theme-core' ),
					'param_name' => 'pagination_top_margin',
					'placeholder' => '30px',
					'description' => esc_html__( 'Allowed units:', 'total-theme-core' ) . ' px, em, rem, vw, vmin, vmax.<br>' . esc_html__( 'Allowed CSS functions:', 'total-theme-core' ) . ' calc(), clamp().',
					'group' => esc_html__( 'Pagination', 'total-theme-core' ),
					'css' => [
						'property' => 'margin-top',
						'selector' => '.wpex-post-cards-pagination',
					],
					'dependency' => [ 'element' => 'pagination', 'value' => [ 'numbered', 'numbered_ajax', 'loadmore', 'infinite_scroll' ] ],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Alignment', 'total-theme-core' ),
					'param_name' => 'pagination_align',
					'group' => esc_html__( 'Pagination', 'total-theme-core' ),
					'dependency' => [ 'element' => 'pagination', 'value' => [ 'numbered', 'numbered_ajax' ] ],
					'css' => [
						'property' => 'text-align',
						'selector' => '.wpex-pagination',
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Load More Button Text', 'total-theme-core' ),
					'param_name' => 'loadmore_text',
					'group' => esc_html__( 'Pagination', 'total-theme-core' ),
					'dependency' => [ 'element' => 'pagination', 'value' => 'loadmore' ],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Entry
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Title Font Size', 'total-theme-core' ),
					'param_name' => 'title_font_size',
					'value' => vcex_font_size_choices(),
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Title Tag', 'total-theme-core' ),
					'param_name' => 'title_tag',
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => '',
						'h2' => 'h2',
						'h3' => 'h3',
						'h4' => 'h4',
						'h5' => 'h5',
						'h6' => 'h6',
						'div' => 'div',
					),
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Media Width', 'total-theme-core' ),
					'param_name' => 'media_width',
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => '',
						'20%'  => '20',
						'25%'  => '25',
						'30%'  => '30',
						'33%'  => '33',
						'40%'  => '40',
						'50%'  => '50',
						'60%'  => '60',
						'70%'  => '70',
						'80%'  => '80',
					),
					'description' => esc_html__( 'Applies to card styles that have the media (image/video) displayed to the side.', 'total-theme-core' ),
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Media Max-Width', 'total-theme-core' ),
					'param_name' => 'media_max_width',
					'description' => esc_html__( 'Allows you to set a max-width for the media element. For example if you select 60% above for the media width but want to make sure the image is never larger than 200px wide you can enter 200px here.', 'total-theme-core' ),
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'css' => [
						'property' => '--wpex-card-media-max-width',
						'selector' => '.wpex-post-cards-loop',
					],
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Breakpoint', 'total-theme-core' ),
					'param_name' => 'media_breakpoint',
					'value' => self::get_media_breakpoint_choices(),
					'description' => esc_html__( 'The breakpoint at which a left/right card styles swaps to a column view. The default for most cards is "md".', 'total-theme-core' ),
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_image_sizes',
					'heading' => esc_html__( 'Thumbnail Size', 'total-theme-core' ),
					'param_name' => 'thumbnail_size',
					'std' => 'full',
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'description' => esc_html__( 'Note: For security reasons custom cropping only works on images hosted on your own server in the WordPress uploads folder. If you are using an external image it will display in full.', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_image_crop_locations',
					'heading' => esc_html__( 'Thumbnail Crop Location', 'total-theme-core' ),
					'param_name' => 'thumbnail_crop',
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'dependency' => array( 'element' => 'thumbnail_size', 'value' => 'wpex_custom' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail Crop Width', 'total-theme-core' ),
					'param_name' => 'thumbnail_width',
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'dependency' => array( 'element' => 'thumbnail_size', 'value' => 'wpex_custom' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail Crop Height', 'total-theme-core' ),
					'param_name' => 'thumbnail_height',
					'description' => esc_html__( 'Leave empty to disable vertical cropping and keep image proportions.', 'total-theme-core' ),
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'dependency' => array( 'element' => 'thumbnail_size', 'value' => 'wpex_custom' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Excerpt Length', 'total-theme-core' ),
					'param_name' => 'excerpt_length',
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'description' => esc_html__( 'Enter how many words to display for the excerpt. To display the full post content enter "-1". To display the full post content up to the "more" tag enter "9999".', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Date Format', 'total-theme-core' ),
					'param_name' => 'date_format',
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'description' => sprintf( esc_html__( 'Change the default card date format using one of the %sallowed format strings%s', 'total-theme-core' ), '<a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank" rel="noopener noreferrer">', '</a>' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom More Link Text', 'total-theme-core' ),
					'param_name' => 'more_link_text',
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'description' => esc_html__( 'You can enter "0" to disable.', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'param_name' => 'card_el_class',
					'group' => esc_html__( 'Entry', 'total-theme-core' ),
					'description' => esc_html__( 'Extra class name to apply to the ".wpex-card" element.', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Carousel Settings
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Arrows', 'total-theme-core' ),
					'param_name' => 'arrows',
					'std' => 'true',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'choices' => 'carousel_arrow_styles',
					'heading' => esc_html__( 'Arrows Style', 'total-theme-core' ),
					'param_name' => 'arrows_style',
					'dependency' => array( 'element' => 'arrows', 'value' => 'true' ),
					'elementor' => [
						'condition' => [
							'display_type' => 'carousel',
							'arrows' => 'true',
						],
					],
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'choices' => 'carousel_arrow_positions',
					'heading' => esc_html__( 'Arrows Position', 'total-theme-core' ),
					'param_name' => 'arrows_position',
					'dependency' => array( 'element' => 'arrows', 'value' => 'true' ),
					'std' => 'default',
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'elementor' => [
						'condition' => [
							'display_type' => 'carousel',
							'arrows' => 'true',
						],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Dot Navigation', 'total-theme-core' ),
					'param_name' => 'dots',
					'std' => 'false',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Auto Play', 'total-theme-core' ),
					'param_name' => 'auto_play',
					'std' => 'false',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Autoplay interval timeout.', 'total-theme-core' ),
					'param_name' => 'timeout_duration',
					'placeholder' => '5000',
					'description' => esc_html__( 'Time in milliseconds between each auto slide. Default is 5000.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'auto_play', 'value' => 'true' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Infinite Loop', 'total-theme-core' ),
					'param_name' => 'infinite_loop',
					'std' => 'true',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Center Item', 'total-theme-core' ),
					'param_name' => 'center',
					'std' => 'false',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Animation Speed', 'total-theme-core' ),
					'param_name' => 'animation_speed',
					'placeholder' => '250',
					'description' => esc_html__( 'Default is 250 milliseconds. Enter 0.0 to disable.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Items To Display', 'total-theme-core' ),
					'param_name' => 'items',
					'placeholder' => '4',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Auto Height?', 'total-theme-core' ),
					'param_name' => 'auto_height',
					'dependency' => array( 'element' => 'items', 'value' => '1' ),
					'description' => esc_html__( 'Allows the carousel to change height based on the active item. This setting is used only when you are displaying 1 item per slide.', 'total-theme-core' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Items To Scrollby', 'total-theme-core' ),
					'param_name' => 'items_scroll',
					'placeholder' => '1',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Tablet: Items To Display', 'total-theme-core' ),
					'param_name' => 'tablet_items',
					'placeholder' => '3',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Mobile Landscape: Items To Display', 'total-theme-core' ),
					'param_name' => 'mobile_landscape_items',
					'placeholder' => '2',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Mobile Portrait: Items To Display', 'total-theme-core' ),
					'param_name' => 'mobile_portrait_items',
					'placeholder' => '1',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Margin Between Items', 'total-theme-core' ),
					'param_name' => 'items_margin',
					'placeholder' => '15',
					'dependency' => array( 'element' => 'display_type', 'value' => 'carousel' ),
					'group' => esc_html__( 'Carousel Settings', 'total-theme-core' ),
					'label_block' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Media
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Allowed Media Types', 'total-theme-core' ),
					'param_name' => 'allowed_media',
					'std' => 'thumbnail',
					'value' => array(
						esc_html__( 'Thumbnail', 'js_composer' ) => 'thumbnail',
						esc_html__( 'Video', 'js_composer' ) => 'video',
					//	esc_html__( 'Audio', 'js_composer' ) => 'audio',
					//	esc_html__( 'Gallery', 'js_composer' ) => 'gallery',
					),
					'description' => esc_html__( 'Note: Not all card styles support all media types.', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'group' => esc_html__( 'Media', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Thumbnail Overlay', 'total-theme-core' ),
					'param_name' => 'thumbnail_overlay_style',
					'group' => esc_html__( 'Media', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Overlay Button Text', 'total-theme-core' ),
					'param_name' => 'thumbnail_overlay_button_text',
					'group' => esc_html__( 'Media', 'total-theme-core' ),
					'dependency' => array( 'element' => 'thumbnail_overlay_style', 'value' => 'hover-button' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Image Hover', 'total-theme-core' ),
					'choices' => 'image_hovers',
					'param_name' => 'thumbnail_hover',
					'group' => esc_html__( 'Media', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Image Filter', 'total-theme-core' ),
					'param_name' => 'thumbnail_filter',
					'group' => esc_html__( 'Media', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'param_name' => 'media_el_class',
					'description' => esc_html__( 'Extra class name to apply to the ".wpex-card-thumbnail" element.', 'total-theme-core' ),
					'group' => esc_html__( 'Media', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Link
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Link Type', 'total-theme-core' ),
					'param_name' => 'link_type',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => '',
						esc_html__( 'Link to post', 'total-theme-core' ) => 'post',
						esc_html__( 'Lightbox', 'total-theme-core' ) => 'lightbox',
						esc_html__( 'Modal Popup', 'total-theme-core' ) => 'modal',
						esc_html__( 'None', 'total-theme-core' ) => 'none',
					),
					'editors' => [ 'wpbakery', 'elementor' ],
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => [ 'woocommerce' ],
					],
					'description' => esc_html__( 'By default all cards link to the post unless set differently when creating custom cards.', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Modal Title', 'total-theme-core' ),
					'param_name' => 'modal_title',
					'std' => 'true',
					'dependency' => array( 'element' => 'link_type', 'value' => 'modal' ),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_template_select',
					'heading' => esc_html__( 'Modal Template', 'total-theme-core' ),
					'param_name' => 'modal_template',
					'dependency' => array( 'element' => 'link_type', 'value' => 'modal' ),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Link Target', 'total-theme-core' ),
					'param_name' => 'link_target',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'value' => array(
						esc_html__( 'Same Tab', 'total-theme-core' ) => '',
						esc_html__( 'New Tab', 'total-theme-core' ) => '_blank',
					),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => [ 'woocommerce' ],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Link Rel', 'total-theme-core' ),
					'param_name' => 'link_rel',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'dependency' => [
						'element' => 'card_style',
						'value_not_equal_to' => [ 'woocommerce' ],
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Featured
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Featured Card', 'total-theme-core' ),
					'param_name' => 'featured_card',
					'std' => 'false',
					'description' => esc_html__( 'Enable to display the first entry as a "featured" card with it\'s own unique style above the other entries.', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_wpex_card_select',
					'heading' => esc_html__( 'Featured Card Style', 'total-theme-core' ),
					'param_name' => 'featured_style',
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Featured Post', 'total-theme-core' ),
					'param_name' => 'featured_post_id',
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'settings' => array(
						'multiple' => false,
						'min_length' => 1,
						'groups' => false,
						'unique_values' => true,
						'display_inline' => false,
						'delay' => 0,
						'auto_focus' => true,
					),
					'elementor' => [
						'type' => 'text',
						'description' => esc_html__( 'Enter your Featured Post ID.', 'total-theme-core' ),
					],
					'dependency' => array(
						'element' => 'query_type',
						'value_not_equal_to' => [ 'post_gallery', 'attachments' ]
					),
					'description' => esc_html__( 'Start typing a post name to locate and select it. Leave empty to display the first post as the featured post.', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Display on Paginated Pages', 'total-theme-core' ),
					'param_name' => 'featured_show_on_paged',
					'std' => 'true',
					'description' => esc_html__( 'If disabled your posts per page count does not need to include the featured post.', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Placement', 'total-theme-core' ),
					'param_name' => 'featured_location',
					'value' => array(
						esc_html__( 'Top', 'total-theme-core' ) => 'top',
						esc_html__( 'Left', 'total-theme-core' ) => 'left',
						esc_html__( 'Right', 'total-theme-core' ) => 'right',
					),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Width', 'total-theme-core' ),
					'param_name' => 'featured_width',
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => '',
						'70%' => '70%',
						'67%' => '67%',
						'60%' => '60%',
						'50%' => '50%',
					),
					'dependency' => array( 'element' => 'featured_location', 'value' => array( 'left', 'right' ) ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Breakpoint', 'total-theme-core' ),
					'param_name' => 'featured_breakpoint',
					'value' => vcex_breakpoint_choices(),
					'dependency' => array( 'element' => 'featured_location', 'value' => array( 'left', 'right' ) ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Margin', 'total-theme-core' ),
					'param_name' => 'featured_margin',
					'value' => vcex_margin_choices(),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Divider Style', 'total-theme-core' ),
					'param_name' => 'featured_divider',
					'value' => array(
						esc_html__( 'None', 'total-theme-core' ) => '',
						esc_html__( 'Solid', 'total-theme-core' ) => 'solid',
						esc_html__( 'Dashed', 'total-theme-core' ) => 'dashed',
						esc_html__( 'Dotted', 'total-theme-core' ) => 'dotted',
					),
					'dependency' => array( 'element' => 'featured_location', 'value' => 'top' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Divider Size', 'total-theme-core' ),
					'param_name' => 'featured_divider_size',
					'value' => vcex_border_width_choices(),
					'dependency' => array( 'element' => 'featured_divider', 'not_empty' => true ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Divider Margin', 'total-theme-core' ),
					'param_name' => 'featured_divider_margin',
					'value' => vcex_margin_choices(),
					'dependency' => array( 'element' => 'featured_divider', 'not_empty' => true ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'List Divider Color', 'total-theme-core' ),
					'param_name' => 'featured_divider_color',
					'css' => [
						'property' => 'border-color',
						'selector' => '.wpex-post-cards-featured-card-divider',
					],
					'dependency' => array( 'element' => 'featured_divider', 'not_empty' => true ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Title Font Size', 'total-theme-core' ),
					'param_name' => 'featured_title_font_size',
					'value' => vcex_font_size_choices(),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Title Tag', 'total-theme-core' ),
					'param_name' => 'featured_title_tag',
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => '',
						'h2' => 'h2',
						'h3' => 'h3',
						'h4' => 'h4',
						'h5' => 'h5',
						'h6' => 'h6',
						'div' => 'div',
					),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Media Width', 'total-theme-core' ),
					'param_name' => 'featured_media_width',
					'value' => array(
						esc_html__( 'Default', 'total-theme-core' ) => '',
						'20%'  => '20',
						'25%'  => '25',
						'30%'  => '30',
						'33%'  => '33',
						'40%'  => '40',
						'50%'  => '50',
						'60%'  => '60',
						'70%'  => '70',
						'80%'  => '80',
					),
					'description' => esc_html__( 'Applies to card styles that have the media (image/video) displayed to the side.', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Media Max-Width', 'total-theme-core' ),
					'param_name' => 'featured_media_max_width',
					'description' => esc_html__( 'Allows you to set a max-width for the media element. For example if you select 60% above for the media width but want to make sure the image is never larger than 200px wide you can enter 200px here.', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'css' => [
						'property' => '--wpex-card-media-max-width',
						'selector' => '.wpex-post-cards-featured',
					],
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Breakpoint', 'total-theme-core' ),
					'param_name' => 'featured_media_breakpoint',
					'value' => self::get_media_breakpoint_choices(),
					'description' => esc_html__( 'The breakpoint at which a left/right card styles swaps to a column view. The default for most cards is "md".', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_image_sizes',
					'heading' => esc_html__( 'Thumbnail Size', 'total-theme-core' ),
					'param_name' => 'featured_thumbnail_size',
					'std' => 'full',
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'description' => esc_html__( 'Note: For security reasons custom cropping only works on images hosted on your own server in the WordPress uploads folder. If you are using an external image it will display in full.', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_image_crop_locations',
					'heading' => esc_html__( 'Thumbnail Crop Location', 'total-theme-core' ),
					'param_name' => 'featured_thumbnail_crop',
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => array( 'element' => 'featured_thumbnail_size', 'value' => 'wpex_custom' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail Crop Width', 'total-theme-core' ),
					'param_name' => 'featured_thumbnail_width',
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => array( 'element' => 'featured_thumbnail_size', 'value' => 'wpex_custom' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail Crop Height', 'total-theme-core' ),
					'param_name' => 'featured_thumbnail_height',
					'description' => esc_html__( 'Leave empty to disable vertical cropping and keep image proportions.', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => array( 'element' => 'featured_thumbnail_size', 'value' => 'wpex_custom' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Excerpt Length', 'total-theme-core' ),
					'param_name' => 'featured_excerpt_length',
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'description' => esc_html__( 'Enter how many words to display for the excerpt. To display the full post content enter "-1". To display the full post content up to the "more" tag enter "9999".', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom More Link Text', 'total-theme-core' ),
					'param_name' => 'featured_more_link_text',
					'description' => esc_html__( 'You can enter "0" to disable.', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'param_name' => 'featured_el_class',
					'description' => esc_html__( 'Extra class name to apply to the ".wpex-card" element.', 'total-theme-core' ),
					'group' => esc_html__( 'Featured', 'total-theme-core' ),
					'dependency' => [
						'element' => 'featured_style',
						'value_not_equal_to' => self::custom_card_styles(),
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Deprecated fields.
				[ 'type' => 'hidden', 'param_name' => 'auto_query' ],
				[ 'type' => 'hidden', 'param_name' => 'custom_query' ],
				[ 'type' => 'hidden', 'param_name' => 'tax_query' ],
				[ 'type' => 'hidden', 'param_name' => 'tax_query_taxonomy' ],
				[ 'type' => 'hidden', 'param_name' => 'tax_query_terms' ], // moved to include_terms
				[ 'type' => 'hidden', 'param_name' => 'pagination_loadmore' ],
				// AJAX fields.
				[ 'type' => 'hidden', 'param_name' => 'query_vars' ],
				[ 'type' => 'hidden', 'param_name' => 'ajax_filter' ],
				[ 'type' => 'hidden', 'param_name' => 'ajax_action' ],
				[ 'type' => 'hidden', 'param_name' => 'ignore_tax_query' ],
			);

			/**
			 * Filters the wpex_post_card shortcode parameters.
			 *
			 * @param array $params
			 * @param string shortcode_tag | wpex_post_cards
			 */
			$params = (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );

			return $params;
		}

		/**
		 * Parses deprecated params.
		 */
		public static function parse_deprecated_attributes( $atts = '' ) {
			if ( empty( $atts ) || ! is_array( $atts ) ) {
				return $atts;
			}

			// Switch to new pagination type.
			if ( isset( $atts['pagination_loadmore'] ) && vcex_validate_att_boolean( 'pagination_loadmore', $atts ) ) {
				$atts['pagination'] = 'loadmore';
				unset( $atts['pagination_loadmore'] );
			} elseif ( isset( $atts['pagination'] ) ) {
				switch ( $atts['pagination'] ) {
					case 'true':
						$atts['pagination'] = 'numbered';
						break;
					case 'false':
						$atts['pagination'] = '';
						break;
				}
			}

			// Switch to new query type.
			if ( empty( $atts['query_type'] ) ) {
				if ( vcex_validate_att_boolean( 'auto_query', $atts ) ) {
					$atts['query_type'] = 'auto';
					unset( $atts['auto_query'] );
				} elseif ( vcex_validate_att_boolean( 'custom_query', $atts ) ) {
					$atts['query_type'] = 'custom';
					unset( $atts['custom_query'] );
				}
			}

			/**
			 * Switch from tax_query_terms to terms_in
			 *
			 * @since 5.6
			 */
			if ( empty( $atts['terms_in'] )
				&& vcex_validate_att_boolean( 'tax_query', $atts )
				&& ! empty( $atts['tax_query_taxonomy'] )
				&& ! empty( $atts['tax_query_terms'] )
				&& is_string( $atts['tax_query_terms'] )
			) {
				$terms_in = [];
				$items = preg_split( '/\,[\s]*/', $atts['tax_query_terms'] );
				if ( is_array( $items ) ) {
					foreach ( $items as $item ) {
						if ( strlen( $item ) > 0 ) {
							if ( is_numeric( $item ) ) {
								$terms_in[] = $item;
							} else {
								if ( 'post-format-standard' === $item ) {
									if ( ! empty( $atts['terms_not_in'] ) ) {
										continue;
									}
									$all_formats = [
										'post-format-aside',
										'post-format-gallery',
										'post-format-link',
										'post-format-image',
										'post-format-quote',
										'post-format-status',
										'post-format-audio',
										'post-format-chat',
										'post-format-video',
									];
									$terms_not_in = [];
									foreach ( $all_formats as $format ) {
										$term_obj = get_term_by( 'slug', $format, 'post_format' );
										if ( $term_obj && ! is_wp_error( $term_obj ) ) {
											$terms_not_in[] = $term_obj->term_taxonomy_id ?? $term_obj->term_id;
										}
									}
									$atts['terms_not_in'] = implode( ',', $terms_not_in );
								} else {
									$term_obj = get_term_by( 'slug', $item, $atts['tax_query_taxonomy'] );
									if ( $term_obj && ! is_wp_error( $term_obj ) ) {
										$terms_in[] = $term_obj->term_taxonomy_id ?? $term_obj->term_id;
									}
								}
							}
						}
					}
					if ( $terms_in ) {
						$atts['terms_in'] = implode( ', ', $terms_in ); // must return string.
						unset( $atts['tax_query'] );
						unset( $atts['tax_query_taxonomy'] );
						unset( $atts['tax_query_terms'] );
					}
				}
			}

			return $atts;
		}

		/**
		 * Returns array of custom card styles to use with dependencies so we can hide various settings
		 * if a custom card is selected.
		 */
		protected static function custom_card_styles() {
			static $custom_styles = null;
			if ( is_null( $custom_styles ) ) {
				$custom_styles = [ 'woocommerce' ];
				$templates = Card_Builder::instance()->get_custom_cards();
				if ( is_array( $templates ) ) {
					foreach ( $templates as $template_id ) {
						$custom_styles[] = 'template_' . $template_id;
					}
				}
			}
			return $custom_styles;
		}

		/**
		 * Returns array of breakpoint choices for the media element.
		 */
		public static function get_media_breakpoint_choices( $add_false = true ) {
			$choices = (array) vcex_breakpoint_choices();
			if ( $choices && $add_false ) {
				$choices[esc_html__( 'Do not stack', 'total-theme-core' )] = 'false';
			}
			return $choices;
		}

	}

}
new Wpex_Post_Cards_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_wpex_post_cards' ) ) {
	class WPBakeryShortCode_wpex_post_cards extends WPBakeryShortCode {}
}