<?php
defined( 'ABSPATH' ) || exit;

/**
 * Star Rating Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
if ( ! class_exists( 'Vcex_Star_Rating_Shortcode' ) ) {

	class Vcex_Star_Rating_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_star_rating';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Star_Rating;
			}
		}

		/**
		 * Shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'Star Rating', 'total-theme-core' );
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}
			$atts = vcex_shortcode_atts( self::TAG, $atts, __CLASS__ );
			ob_start();
			$shortcode_css = new TotalThemeCore\Vcex\Shortcode_CSS( __CLASS__, $atts );
			if ( $shortcode_css->render_style() ) {
				$atts['vcex_class'] = $shortcode_css->unique_classname;
			}
			do_action( 'vcex_shortcode_before', self::TAG, $atts );
			include vcex_get_shortcode_template( self::TAG );
			do_action( 'vcex_shortcode_after', self::TAG, $atts );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = [
				[
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Scale', 'total-theme-core' ),
					'param_name' => 'scale',
					'choices' => [
						'0-5' => '0-5',
						'0-10' => '0-10',
					],
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'textfield',
					'heading' => esc_html__( 'Value', 'total-theme-core' ),
					'param_name' => 'value',
					'admin_label' => true,
					'description' => esc_html__( 'Leave empty to display the current post rating.', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Icon Type', 'total-theme-core' ),
					'param_name' => 'icon_type',
					'choices' => [
						'' => esc_html__( 'Theme Icon', 'total-theme-core' ),
						'material' => esc_html__( 'Material Design', 'total-theme-core' ),
					],
					'description' => vcex_shortcode_param_description( 'text' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Show number', 'total-theme-core' ),
					'param_name' => 'show_number',
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'textfield',
					'heading' => esc_html__( 'Label', 'total-theme-core' ),
					'param_name' => 'label',
					'admin_label' => true,
					'description' => vcex_shortcode_param_description( 'text' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'vcex_select',
					'std' => 'top',
					'heading' => esc_html__( 'Label Position', 'total-theme-core' ),
					'param_name' => 'label_position',
					'choices' => [
						'top' => esc_html__( 'Top', 'total-theme-core' ),
						'inline' => esc_html__( 'Inline', 'total-theme-core' ),
					],
					'dependency' => [ 'element' => 'label', 'not_empty' => true ],
					'description' => vcex_shortcode_param_description( 'text' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				// Style.
				[
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Align', 'total-theme-core' ),
					'param_name' => 'align',
					'css' => [
						'property' => 'text_align',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Icon Size', 'total-theme-core' ),
					'param_name' => 'icon_font_size',
					'css' => [
						'selector' => '.vcex-star-rating__stars',
						'property' => 'font-size',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Star Color', 'total-theme-core' ),
					'param_name' => 'star_color',
					'css' => [
						'selector' => '.vcex-star-rating__stars',
						'property' => 'color',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Label Color', 'total-theme-core' ),
					'param_name' => 'label_color',
					'css' => [
						'selector' => '.vcex-star-rating__label',
						'property' => 'color',
					],
					'dependency' => [ 'element' => 'label', 'not_empty' => true ],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				[
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Number Color', 'total-theme-core' ),
					'param_name' => 'number_color',
					'css' => [
						'selector' => '.vcex-star-rating__number',
						'property' => 'color',
					],
					'dependency' => [ 'element' => 'show_number', 'value' => 'true' ],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				],
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Spacing Between Starts', 'total-theme-core' ),
					'param_name' => 'stars_gap',
					'choices' => 'gap',
					'css' => [
						'selector' => '.vcex-star-rating__stars',
						'property' => 'gap',
					],
					'description' => vcex_shortcode_param_description( 'gap' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Label Spacing', 'total-theme-core' ),
					'param_name' => 'label_margin',
					'choices' => 'gap',
					'css' => [
						'selector' => '{{WRAPPER}}',
						'property' => '--vcex-star-rating-label-margin',
					],
					'dependency' => [ 'element' => 'label', 'not_empty' => true ],
					'description' => vcex_shortcode_param_description( 'gap' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Number Spacing', 'total-theme-core' ),
					'param_name' => 'number_margin',
					'choices' => 'gap',
					'css' => [
						'selector' => '.vcex-star-rating__number',
						'property' => 'margin-left',
					],
					'dependency' => [ 'element' => 'show_number', 'value' => 'true' ],
					'description' => vcex_shortcode_param_description( 'gap' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Typography
				[
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Label Font Size', 'total-theme-core' ),
					'param_name' => 'label_font_size',
					'css' => [
						'selector' => '.vcex-star-rating__label',
						'property' => 'font-size',
					],
					'dependency' => [ 'element' => 'label', 'not_empty' => true ],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				],
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Label Font Weight', 'total-theme-core' ),
					'param_name' => 'label_font_weight',
					'choices' => 'font_weight',
					'css' => [
						'selector' => '.vcex-star-rating__label',
						'property' => 'font-weight',
					],
					'dependency' => [ 'element' => 'label', 'not_empty' => true ],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				),
				[
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Number Font Size', 'total-theme-core' ),
					'param_name' => 'number_font_size',
					'css' => [
						'selector' => '.vcex-star-rating__number',
						'property' => 'font-size',
					],
					'dependency' => [ 'element' => 'show_number', 'value' => 'true' ],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				],
				[
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Number Font Weight', 'total-theme-core' ),
					'param_name' => 'number_font_weight',
					'choices' => 'font_weight',
					'css' => [
						'selector' => '.vcex-star-rating__number',
						'property' => 'font-weight',
					],
					'dependency' => [ 'element' => 'show_number', 'value' => 'true' ],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				],
				// Elementor exclusive
				[
					'type' => 'typography',
					'heading' => esc_html__( 'Label Font', 'total-theme-core' ),
					'param_name' => 'label_typography',
					'selector' => '.vcex-star-rating__label',
					'dependency' => [ 'element' => 'label', 'not_empty' => true ],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
					'editors' => [ 'elementor' ],
				],
				[
					'type' => 'typography',
					'heading' => esc_html__( 'Number Font', 'total-theme-core' ),
					'param_name' => 'number_typography',
					'selector' => '.vcex-star-rating__number',
					'dependency' => [ 'element' => 'show_number', 'value' => 'true' ],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
					'editors' => [ 'elementor' ],
				],
			];

			/**
			 * Filters the vcex_star_rating element params.
			 *
			 * @param array $params
			 */
			$params = (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );

			return $params;
		}

	}

}
new Vcex_Star_Rating_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Star_Rating' ) ) {
	class WPBakeryShortCode_Vcex_Star_Rating extends WPBakeryShortCode {}
}