<?php
defined( 'ABSPATH' ) || exit;

/**
 * Spacing Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
if ( ! class_exists( 'Vcex_Spacing_Shortcode' ) ) {

	class Vcex_Spacing_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_spacing';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Spacing;
			}
		}

		/**
		 * Shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'Spacing', 'total-theme-core' );
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}
			ob_start();
			include vcex_get_shortcode_template( self::TAG );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				array(
					'type' => 'vcex_text',
					'admin_label' => true,
					'heading' => esc_html__( 'Size', 'total-theme-core' ),
					'param_name' => 'size',
					'placeholder' => '30px',
					'dependency' => array( 'element' => 'responsive', 'value' => 'false' ),
					'description' => esc_html__( 'This field accepts any value that can be applied to the height property. This means you can px, em, rem, vmin, vmax even calc()!', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Responsive?', 'total-theme-core' ),
					'param_name' => 'responsive',
					'value' => 'false',
				),
				array(
					'type' => 'vcex_responsive_sizes',
					'heading' => esc_html__( 'Height', 'total-theme-core' ),
					'param_name' => 'size_responsive',
					'value' => '30px',
					'expanded' => true,
					'description' => vcex_shortcode_param_description( 'height' ),
					'dependency' => array( 'element' => 'responsive', 'value' => 'true' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'class',
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
					'param_name' => 'visibility',
				),
			);

			/**
			 * Filters the vcex_spacing shortcode params
			 *
			 * @param array $params
			 */
			$params = (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );

			return $params;
		}

	}

}
new Vcex_Spacing_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Spacing' ) ) {
	class WPBakeryShortCode_Vcex_Spacing extends WPBakeryShortCode {}
}