<?php
defined( 'ABSPATH' ) || exit;

/**
 * Social Links Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.5
 */
if ( ! class_exists( 'VCEX_Social_Links_Shortcode' ) ) {

	class VCEX_Social_Links_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_social_links';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				TotalThemeCore\WPBakery\Map\Vcex_Social_Links::instance();
			}
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}

			/**
			 * Fallbacks for when you could do something like facebook="" or twitter="" for the social links.
			 * Must run before vcex_shortcode_atts.
			 */
			$has_social_links = ! empty( $atts['social_links'] );

			if ( ! $has_social_links ) {
				$og_atts = $atts;
			}

			// Get shortcode attributes.
			$atts = vcex_shortcode_atts( self::TAG, $atts, __CLASS__ );

			ob_start();
			do_action( 'vcex_shortcode_before', self::TAG, $atts );
			$shortcode_css = new TotalThemeCore\Vcex\Shortcode_CSS( __CLASS__, $atts );
			if ( $shortcode_css->render_style() ) {
				$atts['vcex_class'] = $shortcode_css->unique_classname;
			}
			include vcex_get_shortcode_template( self::TAG );
			do_action( 'vcex_shortcode_after', self::TAG, $atts );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$social_link_select = [
				esc_html__( 'Select', 'total-theme-core' ) => '',
			];

			// Get array of social links to loop through.
			$social_links = vcex_social_links_profiles();

			if ( ! empty( $social_links ) ) {
				foreach ( $social_links as $key => $val ) {
					$social_link_select[$val['label']] = $key;
				}
			}

			$params = array(
				// Social Links
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Post Author Links', 'total-theme-core' ),
					'param_name' => 'author_links',
					'description' => esc_html__( 'Enable to display the social links for the current post author.', 'total-theme-core' ),
					'group' => esc_html__( 'Profiles', 'total-theme-core' ),
				),
				array(
					'type' => 'param_group',
					'param_name' => 'social_links',
					'group' => esc_html__( 'Profiles', 'total-theme-core' ),
					'value' => urlencode( json_encode( array( ) ) ),
					'dependency' => array( 'element' => 'author_links', 'value' => 'false' ),
					'params' => array(
						array(
							'type' => 'dropdown',
							'heading' => esc_html__( 'Site', 'total-theme-core' ),
							'param_name' => 'site',
							'admin_label' => true,
							'value' => $social_link_select,
						),
						array(
							'type' => 'textfield',
							'heading' => esc_html__( 'Link', 'total-theme-core' ),
							'param_name' => 'link',
						),
					),
				),
				// General
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin', // can't name it margin_bottom due to WPBakery parsing issue
					'value' => vcex_margin_choices(),
					'admin_label' => true,
				),
				array(
					'type' => 'vcex_hover_animations',
					'heading' => esc_html__( 'Hover Animation', 'total-theme-core'),
					'param_name' => 'hover_animation',
				),
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Link Target', 'total-theme-core'),
					'param_name' => 'link_target',
					'std' => 'self',
					'choices' => 'link_target',
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Show Labels', 'total-theme-core' ),
					'param_name' => 'show_label',
				),
				array(
					'type' => 'vcex_text',
					'placeholder' => '10px',
					'heading' => esc_html__( 'Gap Between Icon and Label', 'total-theme-core' ),
					'param_name' => 'label_gap',
					'css' => [
						'property' => is_rtl() ? 'margin-left' : 'margin-right',
						'selector' => '.vcex-social-links__icon',
					],
					'dependency' => [ 'element' => 'show_label', 'value' => 'true' ],
					'description' => vcex_shortcode_param_description( 'margin' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Element ID', 'total-theme-core' ),
					'param_name' => 'unique_id',
					'admin_label' => true,
					'description' => vcex_shortcode_param_description( 'unique_id' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'classes',
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
					'param_name' => 'visibility',
				),
				vcex_vc_map_add_css_animation(),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Duration', 'total'),
					'param_name' => 'animation_duration',
					'css' => true,
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Delay', 'total'),
					'param_name' => 'animation_delay',
					'css' => true,
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				// Style
				array(
					'type' => 'vcex_social_button_styles',
					'heading' => esc_html__( 'Style', 'total-theme-core'),
					'param_name' => 'style',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Spacing', 'total-theme-core' ),
					'param_name' => 'spacing',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'value' => vcex_margin_choices(),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Expand Items', 'total-theme-core' ),
					'param_name' => 'expand',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Align', 'total-theme-core' ),
					'param_name' => 'align',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'expand', 'value' => 'false' ),
				),
				array(
					'type' => 'vcex_font_size',
					'target' => 'font-size',
					'heading' => esc_html__( 'Custom Icon Size', 'total-theme-core' ),
					'param_name' => 'size',
					'css' => 'font-size',
					'description' => vcex_shortcode_param_description( 'font_size' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Border Radius', 'total' ),
					'param_name' => 'border_radius',
					'css' => [
						'selector' => '.vcex-social-links__item',
						'property' => 'border-radius',
					],
					'value' => vcex_border_radius_choices(),
					'group' => esc_html__( 'Style', 'total' ),
					'dependency' => array( 'element' => 'style', 'value' => 'none' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Vertical Padding', 'total-theme-core' ),
					'param_name' => 'padding_y',
					'value' => vcex_margin_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'height', 'is_empty' => true ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Horizontal Padding', 'total-theme-core' ),
					'param_name' => 'padding_x',
					'value' => vcex_margin_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'width', 'is_empty' => true ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Width', 'total-theme-core' ),
					'param_name' => 'width',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'width' ),
					'dependency' => array( 'element' => 'expand', 'value' => 'false' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Height', 'total-theme-core' ),
					'param_name' => 'height',
					'css' => [
						'selector' => '.vcex-social-links__item',
						'property' => 'height',
					],
					'description' => vcex_shortcode_param_description( 'height' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total-theme-core' ),
					'param_name' => 'color',
					'css' => [
						'selector' => '.vcex-social-links__item',
						'property' => 'color',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color: Hover', 'total-theme-core' ),
					'param_name' => 'hover_color',
					'css' => [
						'selector' => '.vcex-social-links__item:hover',
						'property' => 'color',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background', 'total-theme-core' ),
					'param_name' => 'bg',
					'css' => [
						'selector' => '.vcex-social-links__item',
						'property' => 'background',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background: Hover', 'total-theme-core' ),
					'param_name' => 'hover_bg',
					'css' => [
						'selector' => '.vcex-social-links__item:hover',
						'property' => 'background',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Border Color', 'total-theme-core' ),
					'param_name' => 'border_color',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'css' => [
						'selector' => '.vcex-social-links__item',
						'property' => 'border-color',
					],
					'dependency' => array(
						'element' => 'style',
						'value' => array(
							'minimal',
							'minimal-rounded',
							'minimal-round',
							'bordered',
							'bordered-rounded',
							'bordered-round',
						)
					),
				),
				// CSS
				array(
					'type' => 'css_editor',
					'heading' => esc_html__( 'Custom CSS applied to each social link.', 'total-theme-core' ),
					'param_name' => 'css',
					'group' => esc_html__( 'CSS', 'total-theme-core' ),
				),
				// Deprecated
				array( 'type' => 'hidden', 'param_name' => 'line_height' ), // @since 1.2.8
			);

			return (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );
		}

	}

}
new VCEX_Social_Links_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Social_Links' ) ) {
	class WPBakeryShortCode_Vcex_Social_Links extends WPBakeryShortCode {}
}