<?php
defined( 'ABSPATH' ) || exit;

/**
 * Searchbar Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
if ( ! class_exists( 'VCEX_Searchbar_Shortcode' ) ) {

	class VCEX_Searchbar_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_searchbar';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_action( 'wp_enqueue_scripts', [ __CLASS__, 'register_scripts' ] );
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Searchbar;
			}
		}

		/**
		 * Register scripts.
		 */
		public static function register_scripts() {
			$js_extension = '.js';

			if ( defined( 'WPEX_MINIFY_JS' ) && WPEX_MINIFY_JS ) {
				$js_extension = '.min.js';
			}

			wp_register_script(
				'vcex-searchbar-clear',
				vcex_asset_url( 'js/shortcodes/vcex-searchbar-clear' . $js_extension ),
				array(),
				TTC_VERSION,
				true
			);
		}


		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}
			ob_start();
			do_action( 'vcex_shortcode_before', self::TAG, $atts );
			include vcex_get_shortcode_template( self::TAG );
			do_action( 'vcex_shortcode_after', self::TAG, $atts );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				// General
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin',
					'value' => vcex_margin_choices(),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
					'param_name' => 'visibility',
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Element ID', 'total-theme-core' ),
					'param_name' => 'unique_id',
					'admin_label' => true,
					'description' => vcex_shortcode_param_description( 'unique_id' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'classes',
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				vcex_vc_map_add_css_animation(),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Duration', 'total'),
					'param_name' => 'animation_duration',
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Delay', 'total'),
					'param_name' => 'animation_delay',
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				// Query
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Advanced Search', 'total-theme-core' ),
					'param_name' => 'advanced_query',
					'group' => esc_html__( 'Query', 'total-theme-core' ),
					'description' => esc_html__( 'Example: ', 'total-theme-core' ) . 'post_type=portfolio&taxonomy=portfolio_category&term=advertising' . '<br>' . esc_html__( 'You can use term=current_term and author=current_author for dynamic templates.', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Widths
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Wrap Width', 'total-theme-core' ),
					'param_name' => 'wrap_width',
					'group' => esc_html__( 'Layout', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'width' ),
				),
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Aligment', 'total-theme-core' ),
					'param_name' => 'wrap_float',
					'std' => 'left',
					'exclude_choices' => array( '', 'default' ),
					'dependency' => array( 'element' => 'wrap_width', 'not_empty' => true ),
					'group' => esc_html__( 'Layout', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Gap', 'total-theme-core' ),
					'param_name' => 'gap',
					'value' => vcex_margin_choices(),
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'description' => esc_html__( 'Spacing between elements. Default is 20px.', 'total-theme-core' ),
					'group' => esc_html__( 'Layout', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Stack at Breakpoint', 'total-theme-core'),
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'param_name' => 'fullwidth_mobile',
					'group' => esc_html__( 'Layout', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Breakpoint', 'total-theme-core' ),
					'param_name' => 'breakpoint',
					'value' => vcex_breakpoint_choices(),
					'dependency' => array( 'element' => 'fullwidth_mobile', 'value' => 'true' ),
					'group' => esc_html__( 'Layout', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Input Width', 'total-theme-core' ),
					'param_name' => 'input_width',
					'description' => vcex_shortcode_param_description( 'width' ),
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Layout', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Button Width', 'total-theme-core' ),
					'param_name' => 'button_width',
					'description' => vcex_shortcode_param_description( 'width' ),
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Layout', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				// Input
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Autofocus', 'total-theme-core'),
					'param_name' => 'autofocus',
					'admin_label' => true,
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Clear Button', 'total-theme-core'),
					'param_name' => 'has_clear',
					'description' => esc_html__( 'Enable to display a clear (x) button when typing so you can clear the search field.', 'total-theme-core'),
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Show Search Query', 'total-theme-core'),
					'param_name' => 'auto_fill',
					'description' => esc_html__( 'Enable to fill the search bar with the currently searched terms when shown on the search results page.', 'total-theme-core'),
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Placeholder', 'total-theme-core' ),
					'param_name' => 'placeholder',
					'placeholder' => esc_html__( 'Keywords...', 'total' ),
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background', 'total-theme-core' ),
					'param_name' => 'input_background_color',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total-theme-core' ),
					'param_name' => 'input_color',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Font Size', 'total-theme-core' ),
					'param_name' => 'input_font_size',
					'description' => vcex_shortcode_param_description( 'font_size' ),
					'group' => esc_html__( 'Input', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Letter Spacing', 'total-theme-core' ),
					'param_name' => 'input_letter_spacing',
					'choices' => 'letter_spacing',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Text Transform', 'total-theme-core' ),
					'param_name' => 'input_text_transform',
					'choices' => 'text_transform',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'choices' => 'font_weight',
					'heading' => esc_html__( 'Font Weight', 'total-theme-core' ),
					'param_name' => 'input_font_weight',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Border Radius', 'total-theme-core' ),
					'param_name' => 'input_border_radius',
					'choices' => 'border_radius',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Border Width', 'total' ),
					'param_name' => 'input_border_width',
					'value' => vcex_border_width_choices(),
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Border Color', 'total-theme-core' ),
					'param_name' => 'input_border_color',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_trbl',
					'heading' => esc_html__( 'Padding', 'total-theme-core' ),
					'param_name' => 'input_padding',
					'description' => vcex_shortcode_param_description( 'padding' ),
					'group' => esc_html__( 'Input', 'total-theme-core' ),
				),
				array(
					'type' => 'typography',
					'heading' => esc_html__( 'Typography', 'total-theme-core' ),
					'param_name' => 'input_typo',
					'selector' => '.vcex-searchbar-input',
					'group' => esc_html__( 'Input', 'total-theme-core' ),
					'editors' => [ 'elementor' ],
				),
				// Submit
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'true',
					'heading' => esc_html__( 'Submit Button', 'total-theme-core'),
					'param_name' => 'has_button',
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Button Text', 'total-theme-core' ),
					'param_name' => 'button_text',
					'placeholder' => esc_html__( 'Search', 'total' ),
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Text Transform', 'total-theme-core' ),
					'param_name' => 'button_text_transform',
					'choices' => 'text_transform',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'choices' => 'font_weight',
					'heading' => esc_html__( 'Font Weight', 'total-theme-core' ),
					'param_name' => 'button_font_weight',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Font Size', 'total-theme-core' ),
					'param_name' => 'button_font_size',
					'description' => vcex_shortcode_param_description( 'font_size' ),
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Letter Spacing', 'total-theme-core' ),
					'param_name' => 'button_letter_spacing',
					'choices' => 'letter_spacing',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Border Radius', 'total-theme-core' ),
					'param_name' => 'button_border_radius',
					'choices' => 'border_radius',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background', 'total-theme-core' ),
					'param_name' => 'button_bg',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background: Hover', 'total-theme-core' ),
					'param_name' => 'button_bg_hover',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total-theme-core' ),
					'param_name' => 'button_color',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color: Hover', 'total-theme-core' ),
					'param_name' => 'button_color_hover',
					'dependency' => array( 'element' => 'has_button', 'value' => 'true' ),
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'typography',
					'heading' => esc_html__( 'Typography', 'total-theme-core' ),
					'param_name' => 'button_typo',
					'selector' => '.vcex-searchbar-button',
					'group' => esc_html__( 'Submit', 'total-theme-core' ),
					'editors' => [ 'elementor' ],
				),
				// CSS
				array(
					'type' => 'css_editor',
					'heading' => esc_html__( 'Input CSS', 'total-theme-core' ),
					'param_name' => 'css',
					'group' => esc_html__( 'CSS', 'total-theme-core' ),
				),
			);

			return (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );
		}

	}

}
new VCEX_Searchbar_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Searchbar' ) ) {
	class WPBakeryShortCode_Vcex_Searchbar extends WPBakeryShortCode {}
}