<?php
defined( 'ABSPATH' ) || exit;

/**
 * Divider Multi-Color Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
if ( ! class_exists( 'Vcex_Multi_Color_Divider_Shortcode' ) ) {

	class Vcex_Multi_Color_Divider_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_divider_multicolor';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Divider_Multicolor;
			}
		}

		/**
		 * Shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'Divider - Multicolor', 'total-theme-core' );
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}
			$atts = vcex_shortcode_atts( self::TAG, $atts, __CLASS__ );
			ob_start();
			do_action( 'vcex_shortcode_before', self::TAG, $atts );
			$shortcode_css = new TotalThemeCore\Vcex\Shortcode_CSS( __CLASS__, $atts );
			if ( $shortcode_css->render_style() ) {
				$atts['vcex_class'] = $shortcode_css->unique_classname;
			}
			include vcex_get_shortcode_template( self::TAG );
			do_action( 'vcex_shortcode_after', self::TAG, $atts );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				array(
					'type' => 'param_group',
					'param_name' => 'colors',
					'value' => urlencode( json_encode( array(
						[ 'value' => '#301961' ],
						[ 'value' => '#452586' ],
						[ 'value' => '#301961' ],
						[ 'value' => '#5f3aae' ],
						[ 'value' => '#01c1a8' ],
						[ 'value' => '#11e2c5' ],
						[ 'value' => '#6ffceb' ],
						[ 'value' => '#b0fbff' ],
					) ) ),
					'params' => array(
						array(
							'type' => 'colorpicker',
							'heading' => esc_html__( 'Color', 'total-theme-core' ),
							'param_name' => 'value',
							'admin_label' => true,
						),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'el_class',
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
					'param_name' => 'visibility',
				),
				// Style
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin',
					'value' => vcex_margin_choices(),
					'admin_label' => true,
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Width', 'total-theme-core' ),
					'param_name' => 'width',
					'placeholder' => '100%',
					'css' => [
						'property' => 'max-width',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Align', 'total-theme-core' ),
					'param_name' => 'align',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Margin Bottom', 'total-theme-core' ) . ' ' . esc_html__( '(legacy option)', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'margin' ),
					'param_name' => 'margin_bottom',
					'css' => [
						'property' => 'margin-bottom'
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Height', 'total-theme-core' ),
					'param_name' => 'height',
					'description' => vcex_shortcode_param_description( 'px' ),
					'placeholder' => '8px',
					'css' => [
						'selector' => '.vcex-divider-multicolor__item',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
			);

			return (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );
		}

	}

}
new Vcex_Multi_Color_Divider_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Divider_Multicolor' ) ) {
	class WPBakeryShortCode_Vcex_Divider_Multicolor extends WPBakeryShortCode {}
}