<?php
defined( 'ABSPATH' ) || exit;

/**
 * Cart Link Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
if ( ! class_exists( 'Vcex_Cart_Link_Shortcode' ) ) {

	class Vcex_Cart_Link_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'cart_link';

		/**
		 * Constructor.
		 */
		public function __construct() {
			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Cart_Link;
			}
		}

		/**
		 * Shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'Cart Link', 'total-theme-core' );
		}

		/**
		 * Shortcode Output.
		 */
		public static function output( $atts = [] ) {
			return vcex_do_shortcode_function( self::TAG, $atts );
		}

		/**
		 * Shortcode params.
		 */
		public static function get_params() {
			$params = array(
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Link to Cart', 'total'),
					'param_name' => 'link',
					'std' => 'true',
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Items', 'total-theme-core' ),
					'param_name' => 'items',
					'std' => 'icon,count,total',
					'value' => array(
						esc_html__( 'Icon', 'total-theme-core' ) => 'icon',
						esc_html__( 'Count', 'total-theme-core' ) => 'count',
						esc_html__( 'Total', 'total-theme-core' ) => 'total',
					),
					'admin_label' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Custom Icon', 'total-theme-core' ),
					'param_name' => 'icon',
					'editors' => [ 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'param_name' => 'el_class',
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type'  => 'vcex_font_family_select',
					'heading'  => esc_html__( 'Font Family', 'total-theme-core' ),
					'param_name'  => 'font_family',
				),
				array(
					'type'  => 'vcex_font_family_select',
					'heading'  => esc_html__( 'Font Family', 'total-theme-core' ),
					'param_name'  => 'font_family',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Font Size', 'total-theme-core' ),
					'param_name' => 'font_size',
					'description' => vcex_shortcode_param_description( 'font_size' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total-theme-core' ),
					'param_name' => 'font_color',
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'typography',
					'heading' => esc_html__( 'Typography', 'total-theme-core' ),
					'param_name' => 'typography',
					'selector' => '.wpex-cart-link',
					'editors' => [ 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Icon Margin', 'total-theme-core' ),
					'param_name' => 'icon_margin',
					'description' => vcex_shortcode_param_description( 'margin' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
			);

			return (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );
		}

	}

}
new Vcex_Cart_Link_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Cart_Link' ) ) {
	class WPBakeryShortCode_Cart_Link extends WPBakeryShortCode {}
}