<?php
namespace TotalThemeCore\Vcex;

defined( 'ABSPATH' ) || exit;

/**
 * Returns choices for settings based on string.
 *
 * @package TotalThemeCore
 * @subpackage Vcex
 * @version 1.5
 */
class Setting_Choices {

	/**
	 * Array of choices.
	 */
	public $choices = [];

	/**
	 * Class Constructor.
	 */
	public function __construct( $string, $args = [] ) {
		if ( is_array( $string ) ) {
			$this->choices = $string;
			return;
		}

		switch ( $string ) {
			case 'html_tag':
				$this->choices = [
					''     => esc_html__( 'Default', 'total-theme-core' ),
					'h1'   => 'h1',
					'h2'   => 'h2',
					'h3'   => 'h3',
					'h4'   => 'h4',
					'h5'   => 'h5',
					'div'  => 'div',
					'span' => 'span',
				];
				break;
			case 'border_style' :
				$this->choices = [
					''       => esc_html__( 'Default', 'total-theme-core' ),
					'solid'  => esc_html__( 'Solid', 'total-theme-core' ),
					'dashed' => esc_html__( 'Dashed', 'total-theme-core' ),
					'dotted' => esc_html__( 'Dotted', 'total-theme-core' ),
				];
				break;
			case 'alert' :
				$this->choices = [
					''        => esc_html__( 'Default', 'total-theme-core' ),
					'info'    => esc_html__( 'Info', 'total-theme-core' ),
					'success' => esc_html__( 'Success', 'total-theme-core' ),
					'warning' => esc_html__( 'Warning', 'total-theme-core' ),
					'error'   => esc_html__( 'Error', 'total-theme-core' ),
				];
				break;
			case 'button_size':
				$this->choices = [
					''       => esc_html__( 'Default', 'total-theme-core' ),
					'small'  => esc_html__( 'Small', 'total-theme-core' ),
					'medium' => esc_html__( 'Medium', 'total-theme-core' ),
					'large'  => esc_html__( 'Large', 'total-theme-core' ),
				];
				break;
			case 'button_layout':
				$this->choices = [
					'inline'   => esc_html__( 'Inline', 'total-theme-core' ),
					'block'    => esc_html__( 'Block', 'total-theme-core' ),
					'expanded' => esc_html__( 'Expanded', 'total-theme-core' ),
				];
				break;
			case 'link_target':
				$this->choices = [
					'self'   => esc_html__( 'Same tab', 'total-theme-core' ),
					'_blank' => esc_html__( 'New tab', 'total-theme-core' )
				];
				break;
			case 'html_tag':
				$this->choices = [
					''     => esc_html__( 'Default', 'total-theme-core' ),
					'h1'   => 'h1',
					'h2'   => 'h2',
					'h3'   => 'h3',
					'h4'   => 'h4',
					'h5'   => 'h5',
					'div'  => 'div',
					'span' => 'span',
				];
				break;
			case 'text_alignments':
			case 'text_align':
			case 'textalign':
				$this->choices = [
					''       => esc_html__( 'Default', 'total-theme-core' ),
					'left'   => esc_html__( 'Left', 'total-theme-core' ),
					'center' => esc_html__( 'Center','total-theme-core' ),
					'right'  => esc_html__( 'Right', 'total-theme-core' ),
				];
				break;
			case 'text_transforms':
			case 'text_transform':
				$this->choices = [
					''           => esc_html__( 'Default', 'total' ),
					'none'       => esc_html__( 'None', 'total' ) ,
					'capitalize' => esc_html__( 'Capitalize', 'total' ),
					'uppercase'  => esc_html__( 'Uppercase', 'total' ),
					'lowercase'  => esc_html__( 'Lowercase', 'total' ),
				];
				break;
			case 'masonry_layout_mode':
				$this->choices = [
					'masonry' => esc_html__( 'Masonry', 'total-theme-core' ),
					'fitRows' => esc_html__( 'Fit Rows', 'total-theme-core' ),
				];
				break;
			case 'grid_style':
				$this->choices = [
					'fit_columns' => esc_html__( 'Fit Columns', 'total-theme-core' ),
					'masonry'     => esc_html__( 'Masonry', 'total-theme-core' ),
				];
				break;
			case 'slider_animation':
				$this->choices = [
					'fade_slides' => esc_html__( 'Fade', 'total-theme-core' ),
					'slide'       => esc_html__( 'Slide', 'total-theme-core' ),
				];
				break;
			case 'image_sizes':
				$sizes = [
					'wpex_custom' => esc_html__( 'Custom Size', 'total-theme-core' ),
				];
				if ( function_exists( 'get_intermediate_image_sizes' ) ) {
					$get_sizes = get_intermediate_image_sizes();
					array_unshift( $get_sizes, 'full' );
					$get_sizes = array_combine( $get_sizes, $get_sizes );
					$sizes = array_merge( $sizes, $get_sizes );
				}
				$this->choices = $sizes;
				break;
			case 'image_crop_locations':
				if ( function_exists( 'wpex_image_crop_locations' ) ) {
					$this->choices = wpex_image_crop_locations();
				}
				break;
			case 'button_styles':
				if ( function_exists( 'wpex_button_styles' ) ) {
					$this->choices = wpex_button_styles();
				}
				break;
			case 'columns_gap':
			case 'gap':
				if ( function_exists( 'wpex_column_gaps' ) ) {
					$this->choices = wpex_column_gaps();
				}
				break;
			case 'hover_animations':
					if ( function_exists( 'wpex_hover_css_animations' ) ) {
						$this->choices = wpex_hover_css_animations();
					}
				break;
			case 'button_colors':
				if ( function_exists( 'wpex_get_accent_colors' ) ) {
					$this->choices =[];
					$colors = wpex_get_accent_colors();
					foreach ( $colors as $key => $settings ) {
						if ( ! empty( $settings[ 'label' ] ) ) {
							$this->choices[( $key == 'default' ) ? '' : $key] = $settings[ 'label' ];
						}
					}
				}
				break;
			case 'template':
				if ( function_exists( 'wpex_choices_dynamic_templates' ) ) {
					$this->choices = wpex_choices_dynamic_templates();
				}
				break;
			case 'font_weight':
				$this->choices = wpex_font_weights();
				break;
			case 'border_radius':
				if ( function_exists( 'wpex_utl_border_radius' ) ) {
					$this->choices = wpex_utl_border_radius( $args['supports_blobs'] ?? false );
				}
				break;
			case 'letter_spacing':
				if ( function_exists( 'wpex_utl_letter_spacing' ) ) {
					$this->choices = wpex_utl_letter_spacing();
				}
				break;
			case 'font_size':
				if ( function_exists( 'wpex_utl_font_sizes' ) ) {
					$this->choices = wpex_utl_font_sizes();
				}
				break;
			case 'grid_columns':
				if ( function_exists( 'wpex_grid_columns' ) ) {
					$this->choices = wpex_grid_columns();
				}
				break;
			case 'overlay_style':
			case 'thumbnail_overlay_style':
				if ( function_exists( 'wpex_overlay_styles_array' ) ) {
					$this->choices = wpex_overlay_styles_array();
				}
				break;
			case 'img_filter':
			case 'image_filter':
			case 'thumbnail_filter':
				if ( function_exists( 'wpex_image_filters' ) ) {
					$this->choices = wpex_image_filters();
				}
				break;
			case 'carousel_arrow_styles':
				if ( function_exists( 'wpex_carousel_arrow_styles' ) ) {
					$this->choices = wpex_carousel_arrow_styles();
				}
				break;
			case 'carousel_arrow_positions':
				if ( function_exists( 'wpex_carousel_arrow_positions' ) ) {
					$this->choices = wpex_carousel_arrow_positions();
				}
				break;
			case 'img_hover':
			case 'image_hovers':
			case 'img_hover_style':
				if ( function_exists( 'wpex_image_hovers' ) ) {
					$this->choices = wpex_image_hovers();
				}
				break;
			case 'line_height':
				if ( function_exists( 'wpex_utl_line_height' ) ) {
					$this->choices = wpex_utl_line_height();
				}
				break;
			case 'shadow':
			case 'shadow_hover':
				if ( function_exists( 'wpex_utl_shadows' ) ) {
					$this->choices = wpex_utl_shadows();
				}
				break;
			case 'font_size':
				if ( function_exists( 'wpex_utl_font_sizes' ) ) {
					$this->choices = wpex_utl_font_sizes();
				}
				break;
			case 'border_width':
				if ( function_exists( 'wpex_utl_border_widths' ) ) {
					$this->choices = wpex_utl_border_widths();
				}
				break;
			case 'margin':
			case 'padding':
			case 'padding_y':
			case 'padding_x':
			case 'padding_all':
			case 'bottom_margin':
			case 'margin_bottom':
				if ( function_exists( 'wpex_utl_margins' ) ) {
					$this->choices = wpex_utl_margins();
				}
				break;
			case 'opacity':
				if ( function_exists( 'wpex_utl_opacities' ) ) {
					$this->choices = wpex_utl_opacities();
				}
				break;
			case 'icon_size':
				if ( function_exists( 'vcex_icon_size_choices' ) ) {
					$this->choices = array_flip( vcex_icon_size_choices() );
				}
				break;
			case 'visibility':
				if ( function_exists( 'wpex_visibility' ) ) {
					$this->choices = wpex_visibility();
				}
				break;
			case 'text_decoration':
				$this->choices = vcex_text_decorations();
				break;
			case 'font_style':
				$this->choices = vcex_font_styles();
				break;
			case 'taxonomy':
				$this->choices = $this->get_taxonomies();
				break;
			case 'callback_functions':
				$this->choices = [
					'' => esc_html__( 'Select', 'total-theme-core' ),
				];
				if ( defined( 'VCEX_CALLBACK_FUNCTION_WHITELIST' ) && is_array( VCEX_CALLBACK_FUNCTION_WHITELIST ) ) {
					$this->choices = array_merge( $this->choices, array_combine( VCEX_CALLBACK_FUNCTION_WHITELIST, VCEX_CALLBACK_FUNCTION_WHITELIST ) );
				}
				break;
			default:
				if ( is_callable( $this->choices ) ) {
					$this->choices = call_user_func( $this->choices );
				}
				break;
		}

		if ( isset( $args['exclude_choices'] ) && is_array( $args['exclude_choices'] ) ) {
			foreach ( $args['exclude_choices'] as $excluded ) {
				unset( $this->choices[$excluded] );
			}
		}

		return $this->choices;
	}

	/**
	 * Return choices.
	 */
	public function get_choices() {
		return $this->choices;
	}

	/**
	 * Return taxonomy choices.
	 */
	protected function get_taxonomies() {
		$taxonomies = [
			'' => '&#8212; ' . esc_html( 'Select', 'total-theme-core' ) . ' &#8212;'
		];

		$get_taxonomies = get_taxonomies( [
			'public' => true,
		], 'objects' );

		foreach ( $get_taxonomies as $get_taxonomy ) {
			$taxonomies[ $get_taxonomy->name ] = ucfirst( $get_taxonomy->labels->singular_name );
		}

		return $taxonomies;
	}

}