<?php
namespace TotalThemeCore\Vcex;

use TotalThemeCore\Vcex\Carousel\Core as Carousel;

defined( 'ABSPATH' ) || exit;

/**
 * Register scripts for use with vcex elements and enqueues global js.
 *
 * @package Total Theme Core
 * @subpackage Vcex
 * @version 1.5
 */
final class Scripts {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Scripts.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}
		return static::$instance;
	}

	/**
	 * Class Constructor.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', [ $this, 'register_scripts' ] );
	}

	/**
	 * Returns JS extension.
	 */
	public function get_js_extension() {
		if ( defined( 'WPEX_MINIFY_JS' ) && WPEX_MINIFY_JS ) {
			return '.min.js';
		} else {
			return '.js';
		}
	}

	/**
	 * Register scripts.
	 */
	public function register_scripts() {
		$js_extension = $this->get_js_extension();

		/* Justified Grid */
		wp_register_script(
			'justifiedGallery',
			vcex_asset_url( 'js/lib/jquery.justifiedGallery' . $js_extension ),
			[ 'jquery' ],
			'3.8.1',
			true
		);

		wp_register_script(
			'vcex-justified-gallery',
			vcex_asset_url( 'js/vcex-justified-gallery' . $js_extension ),
			[ 'jquery', 'justifiedGallery' ],
			TTC_VERSION,
			true
		);

		wp_register_style(
			'vcex-justified-gallery',
			vcex_asset_url( 'css/vcex-justified-gallery.css' ),
			[],
			TTC_VERSION
		);

		/* Isotope Scripts */
		wp_register_script(
			'vcex-isotope-grids',
			vcex_asset_url( 'js/vcex-isotope-grids' . $js_extension ),
			[ 'jquery' ],
			TTC_VERSION,
			true
		);

		/* Carousel Scripts */
		Carousel::register_scripts();

		/* Responsive Text */
		wp_register_script(
			'vcex-responsive-text',
			vcex_asset_url( 'js/vcex-responsive-text' . $js_extension ),
			[],
			TTC_VERSION,
			true
		);

		/**
		 * Responsive CSS.
		 *
		 * @deprecated Soft deprecated in v1.3 in exchange for inline style tags, kept as fallback.
		 */
		wp_register_script(
			'vcex-responsive-css',
			vcex_asset_url( 'js/vcex-responsive-css' . $js_extension ),
			[ 'jquery' ],
			TTC_VERSION,
			true
		);

		/* AJAX */
		Ajax::instance()->register_scripts();
	}

}