<?php
/**
 * Font Icon functions.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */

defined( 'ABSPATH' ) || exit;

/**
 * Returns icon HTML.
 */
function vcex_get_icon_html( $atts, $icon_location = 'icon', $extra_class = '' ) {
	$icon_attrs = [];

	if ( $extra_class ) {
		if ( is_array( $extra_class ) ) {
			$icon_attrs = $extra_class;
		} else {
			$icon_attrs['class'] = $extra_class;
		}
	}

	if ( isset( $atts[$icon_location] ) && is_array( $atts[$icon_location] ) ) {
		if ( is_callable( 'Elementor\\Icons_Manager::render_icon' ) ) {
			$icon_attrs['aria-hidden'] = 'true';
			ob_start();
				Elementor\Icons_Manager::render_icon( $atts[$icon_location], $icon_attrs );
			$icon = ob_get_clean();
			if ( $icon ) {
				return '<span class="vcex-elementor-icon">' . $icon . '</span>';
			}
		}
		return;
	}

	$icon = '';

	// Check if the icon is an array and if so it's likely an Elementor icon.
	if ( isset( $atts[$icon_location] ) && is_array( $atts[$icon_location] ) ) {
		return $atts[$icon_location];
	}

	// Get icon type.
	$icon_type = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : '';

	// Custom icon set for specific library.
	if ( $icon_type && ! empty( $atts[$icon_location . '_' . $icon_type] ) ) {
		$icon = $atts[$icon_location . '_' . $icon_type];
	}

	// Parse the default icon parameter which could be anything really.
	elseif ( ! empty( $atts[ $icon_location ] ) ) {

		// Get icon value
		$icon = $atts[$icon_location];

		// Get icon type if not set.
		if ( ! $icon_type ) {
			$icon_type = vcex_get_icon_type_from_class( $icon );
		}

		// converts old 4.7 fontawesome icons to ticons.
		if ( 'ticons' === $icon_type ) {
			$icon = str_replace( 'fa fa-', 'ticon ticon-', $icon );
		}

		// Icon type is unknown so lets add prefixes.
		if ( ! $icon_type ) {
			$icon = vcex_add_default_icon_prefix( $icon );
		}

	}

	// Extra checks.
	if ( ! $icon || in_array( $icon, array( 'icon', 'none' ) ) ) {
		return '';
	}

	if ( 'ticons' === $icon_type && is_callable( 'TotalTheme\\Theme_Icons::get_icon' ) ) {
		$icon_html = \TotalTheme\Theme_Icons::get_icon( $icon, $icon_attrs );
	} else {
		vcex_enqueue_icon_font( $icon_type, $icon );
		$icon_attrs['aria-hidden'] = 'true';
		if ( isset( $icon_attrs['class'] ) ) {
			$icon_attrs['class'] .= ' ' . $icon;
		} else {
			$icon_attrs['class'] = $icon;
		}
		$icon_html = '<span ' . trim( vcex_parse_html_attributes( $icon_attrs ) ) . '></span>';
	}

	return $icon_html;
}

/**
 * Returns correct icon class based on icon type.
 *
 * @todo deprecate.
 */
function vcex_get_icon_class( $atts, $icon_location = 'icon' ) {
	$icon = '';

	// Check if the icon is an array and if so it's likely an Elementor icon.
	if ( isset( $atts[$icon_location] ) && is_array( $atts[$icon_location] ) ) {
		return $atts[$icon_location];
	}

	// Get icon type.
	$icon_type = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : '';

	// Custom icon set for specific library.
	if ( $icon_type && ! empty( $atts[$icon_location . '_' . $icon_type] ) ) {
		$icon = $atts[$icon_location . '_' . $icon_type];
	}

	// Parse the default icon parameter which could be anything really.
	elseif ( ! empty( $atts[ $icon_location ] ) ) {

		// Get icon value
		$icon = $atts[$icon_location];

		// Get icon type if not set.
		if ( ! $icon_type ) {
			$icon_type = vcex_get_icon_type_from_class( $icon );
		}

		// converts old 4.7 fontawesome icons to ticons.
		if ( 'ticons' === $icon_type ) {
			$icon = str_replace( 'fa fa-', 'ticon ticon-', $icon );
		}

		// Icon type is unknown so lets add prefixes.
		if ( ! $icon_type ) {
			$icon = vcex_add_default_icon_prefix( $icon );
		}

	}

	// Extra checks.
	if ( ! $icon || in_array( $icon, array( 'icon', 'none' ) ) ) {
		return '';
	}

	return $icon;
}

/**
 * Returns correct icon family for specific icon class.
 *
 * @todo update to use str_starts_with
 */
function vcex_get_icon_type_from_class( $icon ) {
	if ( is_array( $icon ) ) {
		return; // elementor icon
	}
	if ( strpos( $icon, 'ticon' ) !== false || strpos( $icon, 'fa fa-' ) !== false ) {
		return 'ticons';
	} elseif ( strpos( $icon, 'fa-' ) !== false ) {
		return 'fontawesome';
	} elseif ( strpos( $icon, 'vc-oi' ) !== false ) {
		return 'openiconic';
	} elseif ( strpos( $icon, 'typcn' ) !== false ) {
		return 'typicons';
	} elseif ( strpos( $icon, 'entypo-icon' ) !== false ) {
		return 'entypo';
	} elseif ( strpos( $icon, 'vc_li' ) !== false ) {
		return 'linecons';
	} elseif ( strpos( $icon, 'vc-material' ) !== false ) {
		return 'material';
	}
}

/**
 * Adds default icon prefix to a non-prefixed icon.
 */
function vcex_add_default_icon_prefix( $icon ) {
	return 'ticon ticon-' . sanitize_html_class( $icon );
}