<?php
namespace TotalThemeCore\Vcex;

defined( 'ABSPATH' ) || exit;

/**
 * Elementor integration.
 *
 * @package TotalThemeCore
 * @subpackage Vcex
 * @version 1.4.9
 */
final class Elementor {

	/**
	 * Custom widgets category id.
	 */
	const CATEGORY_ID = 'vcex';

	/**
	 * Dynamic Category ID.
	 */
	const DYNAMIC_CATEGORY_ID = 'vcex_dynamic';

	/**
	 * WooCommerce Category ID.
	 */
//	const WOO_CATEGORY_ID = 'vcex_woocommerce';

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Scripts.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}
		return static::$instance;
	}

	/**
	 * Class Constructor.
	 */
	public function __construct() {
		if ( ! defined( 'VCEX_ELEMENTOR_INTEGRATION' ) ) {
			define( 'VCEX_ELEMENTOR_INTEGRATION', true );
		}
		add_action( 'elementor/widgets/register', [__CLASS__, 'register_widgets'] );
		add_action( 'elementor/elements/categories_registered', [__CLASS__, 'register_category'] );
		add_action( 'elementor/frontend/after_enqueue_scripts', [__CLASS__, 'editor_scripts'] );
	}

	/**
	 * Register widgets.
	 */
	public static function register_widgets( $widgets_manager ) {
		$widgets = [
			new Elementor\Widgets\Alert,
			new Elementor\Widgets\Button,
			new Elementor\Widgets\Callout,
			new Elementor\Widgets\Contact_Form,
			new Elementor\Widgets\Custom_Field,
			new Elementor\Widgets\Divider_Dots,
			new Elementor\Widgets\Feature_Box,
			new Elementor\Widgets\Heading,
			new Elementor\Widgets\Icon_Box,
			new Elementor\Widgets\Image,
			new Elementor\Widgets\Image_Before_After,
			new Elementor\Widgets\List_Item,
			new Elementor\Widgets\Milestone,
			new Elementor\Widgets\Newsletter,
			new Elementor\Widgets\Pricing,
			new Elementor\Widgets\Teaser,
			new Elementor\Widgets\Testimonials_Slider,
			new Elementor\Widgets\Toggle,
			new Elementor\Widgets\Skillbar,
			new Elementor\Widgets\Star_Rating,
			new Elementor\Widgets\Searchbar,

			// Galleries.
			new Elementor\Widgets\Image_Grid,
			new Elementor\Widgets\Image_Carousel,
			new Elementor\Widgets\Image_Slider,

			// Dynamic
			new Elementor\Widgets\Page_Title,
			new Elementor\Widgets\Post_Media,
			new Elementor\Widgets\Post_Content,
			new Elementor\Widgets\Post_Excerpt,
			new Elementor\Widgets\Post_Series,
			new Elementor\Widgets\Post_Comments,
			new Elementor\Widgets\Author_Bio,
			new Elementor\Widgets\Breadcrumbs,
		];

		if ( get_theme_mod( 'cards_enable', true ) ) {
			$widgets[] = new Elementor\Widgets\Post_Cards;
		}

		if ( class_exists( 'WooCommerce' ) ) {
			$widgets[] = new Elementor\Widgets\Cart_Link;
		//	$widgets[] = new Elementor\Widgets\WooCommerce_Template;
		}

		foreach ( $widgets as $widget ) {
			if ( shortcode_exists( $widget->get_name() ) ) {
				$widgets_manager->register( $widget );
			}
		}
	}

	/**
	 * Register Category.
	 */
	public static function register_category( $elements_manager ) {
		$elements_manager->add_category( self::CATEGORY_ID, array(
			'title' => 'Total',
			'icon'  => 'fa fa-wpexplorer',
		) );

		$elements_manager->add_category( self::DYNAMIC_CATEGORY_ID, array(
			'title' => 'Total' . ' - ' . esc_html__( 'Dynamic', 'total-theme-core' ),
			'icon'  => 'fa fa-wpexplorer',
		) );
		/*if ( class_exists( 'WooCommerce' ) ) {
			$elements_manager->add_category( self::WOO_CATEGORY_ID, array(
				'title' => 'Total' . ' - ' . esc_html__( 'WooCommerce', 'total-theme-core' ),
				'icon'  => 'fa fa-wpexplorer',
			) );
		}*/
	}

	/**
	 * Check if currently in preview mode.
	 */
	public static function is_preview_mode() {
		if ( class_exists( 'Elementor\\Plugin' )
			&& is_object( \Elementor\Plugin::$instance->preview )
			&& is_callable( [ \Elementor\Plugin::$instance->preview, 'is_preview_mode' ] )
			&& \Elementor\Plugin::$instance->preview->is_preview_mode()
		) {
			return true;
		}
	}

	/**
	 * Enqueue JS in the editor.
	 */
	public static function editor_scripts() {
		if ( ! self::is_preview_mode() ) {
			return;
		}
		wp_enqueue_script(
			'vcex-elementor-preview',
			vcex_asset_url( 'js/elementor/vcex-elementor-preview' . Scripts::instance()->get_js_extension() ),
			array(),
			TTC_VERSION,
			true
		);
	}

}