<?php
namespace TotalThemeCore\Vcex\Blocks\Wpex_Card;

use TotalThemeCore\Vcex\Block as Vcex_Block;

defined( 'ABSPATH' ) || exit;

/**
 * Registers the vcex/wpex-card Block.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Block extends Vcex_Block {

	/**
	 * Block setup.
	 */
	public function setup() {
		$this->block_name = 'wpex-card';
		$this->json_path  = __DIR__;

		add_action( 'enqueue_block_editor_assets', [ $this, 'add_card_styles_object' ], 0 );
	}

	/**
	 * Block display.
	 */
	public function render_callback( $atts, $content, $block ) {

		// @todo Fix.
		// $block->context['postId'] won't work as expected in the backend, because of a current Gutenberg bug: https://github.com/WordPress/gutenberg/issues/40714 - so we pass the postID as an attribute as a temp workaround, this ID should not be used on the front-end of course.
		if ( $this->is_editor() ) {
			$atts['post_id'] = $atts['postId'] ?? $block->context['postId'];
			$atts['url'] = '#void'; // prevent issues with the link going to the post cause of Gutenberg bugs.
			global $post;
			$og_post = $post;
			$post = $atts['post_id'];
		} else {
			$atts['post_id'] = get_the_ID();
		}
		if ( isset( $atts['excerpt_length'] ) && '' === $atts['excerpt_length'] ) {
			unset( $atts['excerpt_length'] );
		}
		$atts = array_map( 'sanitize_text_field', $atts );
		$card_html = wpex_get_card( $atts );
		if ( isset( $og_post ) ) {
			$post = $og_post;
		}
		return $card_html;
	}

	/**
	 * Inserts inline script that holds card style options.
	 */
	public function add_card_styles_object() {
		if ( ! function_exists( 'wpex_get_card_styles' ) ) {
			return;
		}

		$styles = [];

		foreach ( wpex_get_card_styles() as $key => $value ) {
			$styles[] = [
				'label' => $value['name'],
				'value' => $key,
			];
		}

		$image_sizes = [];

		if ( function_exists( 'get_intermediate_image_sizes' ) ) {
			$get_sizes = get_intermediate_image_sizes();
			array_unshift( $get_sizes, 'full' );
			$get_sizes = array_combine( $get_sizes, $get_sizes );
			foreach ( $get_sizes as $size => $label ) {
				$image_sizes[] = [
					'label' => $label,
					'value' => $size,
				];
			}
		}

		$overlay_styles = [];
		if ( function_exists( 'wpex_overlay_styles_array' ) ) {
			foreach ( wpex_overlay_styles_array() as $name => $label ) {
				$overlay_styles[] = [
					'label' => $label,
					'value' => $name,
				];
			}
		}

		$data_arr = [
			'styles'        => $styles,
			'imageSizes'    => $image_sizes,
			'overlayStyles' => $overlay_styles,
		];

		$data = 'window.wpexCardData = ' . wp_json_encode( $data_arr );

		wp_add_inline_script( 'vcex-wpex-card-editor-script', $data, 'before' );
	}

}