<?php
namespace TotalThemeCore\Vcex\Blocks\Widget_Title;

use TotalThemeCore\Vcex\Block as Vcex_Block;

defined( 'ABSPATH' ) || exit;

/**
 * Registers the vcex/widget-title Block.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Block extends Vcex_Block {

	/**
	 * Block setup.
	 */
	public function setup() {
		$this->block_name = 'widget-title';
		$this->json_path  = __DIR__;

		add_filter( 'widget_block_dynamic_classname', [ $this, 'add_classname' ], 10, 2 );

		/*
		@todo It would be ideal to use this hook but WP is missing the needed $args parameter in the filter.
		add_filter( 'widget_block_content', [ $this, 'filter_widget_content' ], 50, 3 );
		*/
	}

	/**
	 * Block display.
	 */
	public function render_callback( $atts = [] ) {
		$content = ! empty( $atts['content'] ) ? $atts['content'] : esc_html__( 'Widget Title', 'total-theme-core' );

		$class = 'TotalTheme\\Sidebars\\Primary';

		if ( isset( $atts['location'] ) && 'footer' === $atts['location'] ) {
			$class = 'TotalTheme\\Footer\\Widgets';
		}

		if ( class_exists( $class )
			&& is_callable( [ $class, 'widget_title_args' ] )
		) {
			return $class::widget_title_args()['before'] . wp_kses_post( do_shortcode( $content ) ) . $class::widget_title_args()['after'];
		}
	}

	/**
	 * Add classname to block.
	 */
	public function add_classname( $classname, $block_name ) {
		if ( 'vcex/widget-title' === $block_name ) {
			$classname .= ' widget-title-wrap';
		}
		return $classname;
	}

}