<?php
namespace TotalThemeCore\Vcex\Blocks\Button;

use TotalThemeCore\Vcex\Block as Vcex_Block;

defined( 'ABSPATH' ) || exit;

/**
 * Registers the vcex/alert Block.
 *
 * @package TotalThemeCore
 * @version 1.4
 */
final class Block extends Vcex_Block {

	/**
	 * Block setup.
	 */
	public function setup() {
		$this->block_name = 'button';
		$this->json_path  = __DIR__;
	}

	/**
	 * Block display.
	 */
	public function render_callback( $atts ) {
		$atts = $this->parse_atts( $atts );
		return $this->do_shortcode( 'vcex_button', $atts );
	}

	/**
	 * Parse attributes.
	 */
	public function parse_atts( $atts ) {
		if ( isset( $atts['target_blank'] ) && true === wp_validate_boolean( $atts['target_blank'] ) ) {
			$atts['target'] = '_blank';
			unset( $atts['target_blank'] );
		}
		if ( isset( $atts['expanded'] ) && true === wp_validate_boolean( $atts['expanded'] ) ) {
			$atts['layout'] = 'expanded';
			unset( $atts['expanded'] );
		}
		return $atts;
	}

}