if ( 'function' !== typeof window.vcexToggle ) {
	window.vcexToggle = function( context ) {
		if ( ! context || ! context.childNodes ) {
			context = document;
		}

		let isAnimating = false;

		// -------------------------- HELPERS -------------------------- //

		const winScrollTop = () => {
			const scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
			if ( scrollTop < 0 ) {
				scrollTop = 0; // return 0 if negative to prevent issues with elastic scrolling in Safari.
			}
			return scrollTop;
		};

		const offset = ( element ) => {
			const rect = element.getBoundingClientRect();
			return {
				top: rect.top + winScrollTop(),
				left: rect.left + winScrollTop(),
			};
		};

		const scrollToOpen = ( toggle ) => {
			if ( ! toggle || 'undefined' === typeof wpex || 'function' !== typeof wpex.scrollTo ) {
				return;
			}
			wpex.scrollTo( toggle, -20 ); // @todo allow the -20px to be filterable.
			switchState( toggle, 'open' );
		};

		const wooReviewClick = () => {
			const reviews = document.querySelector( '#wpex-woo-product-accordion-section--reviews' );
			if ( reviews ) {
				const toggle = reviews.closest( '.vcex-toggle' );
				if ( toggle ) {
					scrollToOpen( toggle );
					return true;
				}
			}
		};

		const onChange = () => {
			if ( 'function' === typeof VcWaypoint ) {
				VcWaypoint.refreshAll();
			}
			if ( 'function' === typeof Waypoint ) {
				Waypoint.refreshAll();
			}
		};

		const switchState = ( toggle, action ) => {
			if ( ! toggle ) {
				return;
			}

			const content = toggle.querySelector( '.vcex-toggle__content' );

			if ( ! content || content.classList.contains( 'wpex-transitioning' ) ) {
				return;
			}

			const trigger    = toggle.querySelector( '.vcex-toggle__trigger' );
			const isOpen     = toggle.classList.contains( 'vcex-toggle--active' );
			const isAnimated = ( toggle.dataset.animate && 'false' !== toggle.dataset.animate );
			const duration   = toggle.dataset.duration;

			switch ( action ) {
				case 'open':
					if ( isOpen ) {
						isAnimating = false; // already open.
					} else {
						if ( isAnimated && 'undefined' !== typeof wpex && 'function' === typeof wpex.slideDown ) {
							isAnimating = true;
							wpex.slideDown( content, duration, function() {
								isAnimating = false;
								onChange();
							} );
						} else {
							onChange();
						}
						toggle.classList.add( 'vcex-toggle--active' );
						trigger.setAttribute( 'aria-expanded', 'true' );
					}
					break
				case 'close':
					if ( ! isOpen ) {
						isAnimating = false; // already closed.
					} else {
						if ( isAnimated && 'undefined' !== typeof wpex && 'function' === typeof wpex.slideUp ) {
							content.style.display = 'block'; // fixes animations.
							isAnimating = true;
							wpex.slideUp( content, duration, function() {
								isAnimating = false;
								onChange();
							} );
						} else {
							onChange();
						}
						toggle.classList.remove( 'vcex-toggle--active' );
						trigger.setAttribute( 'aria-expanded', 'false' );
					}
					break;
			}
		};

		// -------------------------- Events -------------------------- //

		const onLoad = () => {
			if ( 'wpex_theme_params' === typeof wpex || 'object' !== typeof wpex_theme_params ) {
				return;
			}
			const hash = location.hash;
			if ( ! hash || 'undefined' === hash || '#' === hash ) {
				return;
			}
			const element = document.querySelector( hash );
			if ( ! element || ! element.classList.contains( 'vcex-toggle__content' ) ) {
				return;
			}
			const toggle = element.closest( '.vcex-toggle' );
			window.setTimeout( function() {
				scrollToOpen( toggle );
			}, parseInt( wpex_theme_params.scrollToHashTimeout ) );
		};

		const localLinks = () => {
			document.querySelectorAll( '.vcex-toggle__content' ).forEach( ( toggleContent ) => {
				if ( toggleContent && toggleContent.id ) {
					document.querySelectorAll( `[href="#${toggleContent.id}"]`).forEach( ( link ) => {
						if ( link.classList.contains( 'vcex-toggle__trigger' ) ) {
							return;
						}
						link.addEventListener( 'click', ( event ) => {
							event.preventDefault();
							scrollToOpen( toggleContent.closest( '.vcex-toggle' ) );
						} );
					} );
				}
			} );
		};

		const onDocClick = ( event ) => {
			const target = event.target;
			if ( target.closest( '.woocommerce-review-link') ) {
				if ( wooReviewClick() ) {
					event.preventDefault();
				}
			}
			const trigger = target.closest( '.vcex-toggle__trigger' );
			if ( ! trigger ) {
				return;
			}

			event.preventDefault();

			if ( isAnimating ) {
				return; // prevent click spam.
			}

			const toggle = trigger.closest( '.vcex-toggle' );
			const isOpen = toggle.classList.contains( 'vcex-toggle--active' );
			const parentContainer = toggle.closest( '.vcex-toggle-group' );
			const accordion = toggle.dataset.accordion;

			if ( parentContainer || ( accordion && 'false' !== accordion ) ) {
				if ( ! parentContainer ) {
					parentContainer = toggle.closest( '.vc_column_container' );
				}
				if ( parentContainer ) {
					parentContainer.querySelectorAll( '.vcex-toggle--active' ).forEach( function( activeToggle ) {
						if ( ! activeToggle.isSameNode( toggle ) ) {
							switchState( activeToggle, 'close' );
						}
					} );
				}
			}

			if ( isOpen ) {
				switchState( toggle, 'close' );
			} else {
				switchState( toggle, 'open' );
			}
		};

		// Add event listeners.
		localLinks();
		document.addEventListener( 'click', onDocClick );
		window.addEventListener( 'load', onLoad );
	};
}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( vcexToggle, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', vcexToggle, false );
}