/*jshint esversion: 6 */
if ( 'function' !== typeof window.vcexNavbarFilter ) {
	window.vcexNavbarFilter = function() {

		const getGridTarget = ( grid ) => {
			if ( grid.classList.contains( 'wpex-post-cards' ) ) {
				return grid.firstChild;
			} else if ( ! grid.classList.contains( 'wpex-row' ) ) {
				return grid.querySelector( '.wpex-row' );
			}
			return grid;
		};

		const toggleLoadMore = ( grid, selector ) => {
			const loadMore = grid.nextSibling;
			if ( ! loadMore || ! loadMore.classList.contains( 'vcex-loadmore' ) ) {
				return;
			}
			if ( '*' === selector ) {
				loadMore.classList.remove( 'wpex-hidden' );
			} else {
				loadMore.classList.add( 'wpex-hidden' );
			}
		};

		const filterGrid = ( grid, selector ) => {
			toggleLoadMore( grid, selector );
			const targetEntry = grid.closest( '.wpex-post-cards' ) ? '.wpex-post-cards-entry' : '.col';
			grid.querySelectorAll( targetEntry ).forEach( element => {
				element.style.display = 'none';

				element.querySelectorAll( '.wpb_animate_when_almost_visible' ).forEach( animated => {
					animated.classList.remove( 'wpb_start_animation', 'animated', 'wpb_animation_queue_item' );
				} );

				if ( 'function' === typeof vc_waypoints ) {
					const event = new CustomEvent( 'vc_waypoints_sequence_destroy' );
					document.dispatchEvent( event );
					vc_waypoints();
				}

				if ( '*' === selector || element.closest( selector ) ) {
					element.style.display = '';
				}

				if ( 'function' === typeof Waypoint ) {
					Waypoint.refreshAll();
				}
			} );
			if ( 'function' === typeof Isotope ) {
				setTimeout( () => {
					const isotope = Isotope.data( grid );
					if ( isotope ) {
						isotope.layout();
					}
				}, 0 );
			}
		};

		// Loops through filter navs to set default active items.
		document.querySelectorAll( '.vcex-filter-nav' ).forEach( function( nav ) {
			let grid = document.querySelector( '#' + nav.dataset.filterGrid );

			if ( ! grid ) {
				return;
			}

			grid = getGridTarget( grid );

			if ( ! grid ) {
				return;
			}

			// Get settings from data attributes.
			const activeItems = nav.dataset.filter;

			if ( activeItems ) {
				filterGrid( grid, activeItems );
			}
		} );

		// Filters grid when clicking on filter links.
		document.addEventListener( 'click', function( event ) {
			var filterLink = event.target.closest( '.vcex-navbar-link' );
			if ( ! filterLink ) {
				return;
			}

			var nav = filterLink.closest( '.vcex-filter-nav' );

			if ( ! nav ) {
				return;
			}

			var grid = document.querySelector( '#' + nav.dataset.filterGrid );

			if ( ! grid ) {
				return;
			}

			grid = getGridTarget( grid );

			if ( ! grid ) {
				return;
			}

			var filter = filterLink.dataset.filter || '*';

			nav.querySelectorAll( '.vcex-navbar-link' ).forEach( function( element ) {
				element.classList.remove( 'active' );
			} );

			filterLink.classList.add( 'active' );

			filterGrid( grid, filter );

			event.preventDefault();
			event.stopPropagation();
		} );

	};
}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( vcexNavbarFilter, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', vcexNavbarFilter, false );
}