( function( $ ) {

	'use strict';

	const init = () => {

		const $genFields      = $( '#wpex-mf-tr--name, #wpex-mf-tr--fallback' );
		const $isGlobal       = $( '#wpex-mf-tr--is_global' );
		const $fontDisplay    = $( '#wpex-mf-tr--display' );
		const $preloadFont    = $( '#wpex-mf-tr--preload' );
		const $typeBoxes      = $( '#wpex-mf-metabox--adobe, #wpex-mf-metabox--google, #wpex-mf-metabox--custom' );
		const $extras         = $( 'wpex-mf-field--type .wpex-mf-field--extras' );
		const $extraBtns      = $( '.wpex-visit-google-btn,.wpex-visit-adobe-btn' );
		const $globalCheckBox = $isGlobal.find( 'input[type="checkbox"' );

		$( '#wpex-mf-field--type' ).change( function() {
			const optionValue = this.value;
			if ( optionValue ) {
				$genFields.show();
				$extras.show();
				$extraBtns.addClass( 'wpex-mf-hidden' );
				$isGlobal.hide();
				$fontDisplay.hide();
				$preloadFont.hide();
				$( '#wpex-mf-metabox--assign' ).show();
				$typeBoxes.not( '#wpex-mf-metabox--' + optionValue ).hide();
				$( '#wpex-mf-metabox--' + optionValue ).show();
				$( '.wpex-visit-' + optionValue + '-btn' ).removeClass( 'wpex-mf-hidden' );
				if ( 'google' === optionValue || 'adobe' === optionValue ) {
					$isGlobal.show();
					if ( $globalCheckBox.is( ':checked' ) ) {
						$preloadFont.show();
					}
				}
				if ( 'google' === optionValue || 'custom' === optionValue ) {
					$fontDisplay.show();
				}
			} else {
				$fontDisplay.hide();
				$extras.hide();
				$typeBoxes.hide();
				$genFields.hide();
				$isGlobal.hide();
				$preloadFont.hide();
				$extraBtns.addClass( 'wpex-mf-hidden' );
				$( '#wpex-mf-metabox--assign' ).hide();
			}
		} ).change(); // invoke on page load.

		$globalCheckBox.get(0).addEventListener( 'change', ( event ) => {
			const fontType = document.querySelector( '#wpex-mf-field--type' ).value;
			if ( event.currentTarget.checked && ( 'google' === fontType || 'adobe' === fontType ) ) {
				$preloadFont.show();
			} else {
				$preloadFont.hide();
			}
		} );

	};

	$( document ).ready( function() {
		init();
	} );

} ) ( jQuery );