<?php
namespace TotalThemeCore;

use TotalThemeCore\WPBakery\Helpers as WPBakery_Helpers;
use TotalThemeCore\Elementor\Helpers as Elementor_Helpers;

defined( 'ABSPATH' ) || exit;

/**
 * Theme Templates Post Type.
 *
 * @package TotalThemeCore
 * @version 1.6.0
 */
final class Dynamic_Templates {

	/**
	 * Card builder post type name.
	 */
	public const POST_TYPE = 'wpex_templates';

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Portfolio.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	private function init_hooks() {
		add_action( 'init', [ $this, 'init' ] );

		if ( is_admin() ) {
			add_action( 'admin_init', [ $this, 'admin_init'] );
		}
	}

	/**
	 * Returns parent menu.
	 */
	public function init() {
		$this->register_post_type();
	}

	/**
	 * Admin hooks.
	 */
	public function admin_init() {
		$this->wpbakery_editor_fixes();

		add_action( 'admin_head-post.php', [ $this, 'add_back_button' ] );
		add_filter( 'manage_' . self::POST_TYPE . '_posts_columns', [ $this, 'add_admin_columns' ] );
		add_action( 'manage_' . self::POST_TYPE . '_posts_custom_column', [ $this, 'display_admin_columns' ], 10, 2 );
	}

	/**
	 * Fixes templatera bug that causes the templates icon to not render.
	 */
	public function wpbakery_editor_fixes() {
		if ( ! defined( 'WPEX_VC_ACTIVE' ) || ! WPEX_VC_ACTIVE || ! $this->is_template_vc_edit() ) {
			return;
		}
		add_filter( 'vc_role_access_with_post_types_get_state', '__return_true' );
		add_filter( 'vc_role_access_with_backend_editor_get_state', '__return_true' );
		add_filter( 'vc_role_access_with_frontend_editor_get_state', '__return_true' );
		add_filter( 'vc_check_post_type_validation', '__return_true' );
		add_filter( 'vc_is_valid_post_type_be', '__return_true' );
		add_filter( 'vc_is_valid_post_type_fe', '__return_true' );
	}

	/**
	 * Add a back button to the Font Manager main page.
	 */
	public function add_back_button() {
		global $current_screen;

		if ( ! empty( $current_screen->post_type ) && self::POST_TYPE !== $current_screen->post_type ) {
			return;
		}

		wp_enqueue_script( 'jQuery' );

		?>

		<script>
			jQuery( function() {
				jQuery( 'body.post-type-<?php echo sanitize_html_class( self::POST_TYPE ); ?> .wrap h1' ).append( '<a href="<?php echo esc_url( admin_url( 'edit.php?post_type=' . self::POST_TYPE ) ); ?>" class="page-title-action" style="margin-left:20px"><?php esc_html_e( 'View All', 'total-theme-core' ); ?></a>' );
			} );
		</script>

		<?php
	}

	/**
	 * Define new admin dashboard columns.
	 */
	public function add_admin_columns( $columns ) {
		$new_columns = [
			'wpex_template_id' => esc_html__( 'Template ID', 'total' ),
		];
    	return array_merge( $columns, $new_columns );
	}

	/**
	 * Display new admin dashboard columns.
	 */
	public function display_admin_columns( $column, $post_id ) {
		switch ( $column ) {
			case 'wpex_template_id' :
				echo esc_html( absint( $post_id ) );
			break;
		}
	}

	/**
	 * Checks if we are currently editing a dynamic template.
	 */
	protected function is_template_vc_edit() {
		$post_type = get_post_type();
		if ( empty( $post_type ) && function_exists( 'vc_get_param' ) ) {
			if ( vc_get_param( 'post' ) ) {
				$post_type = get_post_type( (int) vc_get_param( 'post' ) );
			} elseif ( vc_get_param( 'post_type' ) ) {
				$post_type = vc_get_param( 'post_type' );
			}
		}

		return $post_type === self::POST_TYPE;
	}

	/**
	 * Returns parent menu.
	 */
	protected function get_parent_menu() {
		return defined( 'WPEX_THEME_PANEL_SLUG' ) ? WPEX_THEME_PANEL_SLUG : 'themes.php';
	}

	/**
	 * Registers the custom post type.
	 */
	public function register_post_type() {
		$args = [
			'labels' => [
				'name' => esc_html__( 'Dynamic Templates', 'total-theme-core' ),
				'singular_name' => esc_html__( 'Dynamic Template', 'total-theme-core' ),
				'add_new' => esc_html__( 'Add New' , 'total-theme-core' ),
				'add_new_item' => esc_html__( 'Add New Dynamic Template' , 'total-theme-core' ),
				'edit_item' => esc_html__( 'Edit Dynamic Template' , 'total-theme-core' ),
				'new_item' => esc_html__( 'New Dynamic Template' , 'total-theme-core' ),
				'view_item' => esc_html__( 'View Dynamic Template', 'total-theme-core' ),
				'search_items' => esc_html__( 'Search Dynamic Templates', 'total-theme-core' ),
				'not_found' => esc_html__( 'No Dynamic Templates found', 'total-theme-core' ),
				'not_found_in_trash' => esc_html__( 'No Dynamic Templates found in Trash', 'total-theme-core' ),
			],
			'public' => false,
			'has_archive' => false,
			'query_var' => true,
			'_builtin' => false,
			'show_ui' => true,
			'show_in_rest' => true, // enable Gutenberg.
			'show_in_menu' => $this->get_parent_menu(),
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => false,
			'exclude_from_search' => true, // !! important !!
			'publicly_queryable' => false,
			'capability_type' => 'page',
			'hierarchical' => false,
			'menu_position' => null,
			'rewrite' => false,
			'supports' => [
				'title',
				'editor',
			],
			'menu_position' => null,
		];

		if ( Elementor_Helpers::is_cpt_in_frontend_mode( self::POST_TYPE )
			|| WPBakery_Helpers::is_cpt_in_frontend_mode( self::POST_TYPE )
		) {
			$args['public']             = true;
			$args['publicly_queryable'] = true;
		}

		register_post_type( self::POST_TYPE, $args );

		// Add Elementor support.
		add_post_type_support( self::POST_TYPE, 'elementor' );
	}

}