<?php
defined( 'ABSPATH' ) || exit;

$available_plugins = [];

if ( ! empty( $this->demos ) && is_array( $this->demos ) ) {
	$plugins = array_column( $this->demos, 'plugins' );
	if ( $plugins ) {
		$available_plugins = array_unique( call_user_func_array( 'array_merge', $plugins ) );
	}
}

?>

<div class="wpex-demo-import-page wrap">

	<h1><?php esc_html_e( 'Demo Importer', 'total-theme-core' ); ?></h1>

	<?php
	$max_execute = ini_get( 'max_execution_time' );
	if ( $max_execute > 0 && $max_execute < 300 ) { ?>
		<div class="notice notice-error">
			<p style="font-size:1.1em;"><?php echo wp_kses_post( sprintf( __( '<strong>Important:</strong> Your server\'s max_execution_time is set to %d but some demos may require more time to import, especially on shared hosting plans. We highly recommend increasing your server\'s max_execution_time value to at least 300. This can be done via your cPanel or by contacting your hosting company.', 'total-theme-core' ), $max_execute ) ); ?></p>
		</div>
	<?php } ?>

	<div class="wpex-demo-import-top">

		<?php if ( ! empty( $this->categories ) && is_array( $this->categories ) ) : ?>
			<div class="wpex-demo-import-filter">
				<div class="wpex-demo-import-filter__categories">
					<select><?php
						echo '<option value="all">' . esc_html__( 'Filter by Category', 'total-theme-core' ) . '</option>';
						if ( isset( $this->categories[ 'other' ] ) ) {
							$value = $this->categories[ 'other' ];
							unset( $this->categories[ 'other' ] );
							$this->categories[ 'other' ] = $value;
						}
						foreach ( $this->categories as $category_key => $category_value ) {
							echo '<option value="' . esc_attr( $category_key ) . '">' . esc_html( $category_value ) . '</option>';
						}
					?></select>
				</div>
				<div class="wpex-demo-import-filter__builders">
					<select>
						<option value="all"><?php echo esc_html__( 'Filter by Page Builder', 'total-theme-core' ); ?></option>
						<?php if ( in_array( 'WPBakery Page Builder', $available_plugins ) ) { ?>
							<option value="wpbakery"><?php echo esc_html__( 'WPBakery', 'total-theme-core' ); ?></option>
						<?php } ?>
						<?php if ( in_array( 'Elementor', $available_plugins ) ) { ?>
							<option value="elementor"><?php echo esc_html__( 'Elementor', 'total-theme-core' ); ?></option>
						<?php } ?>
						<?php if ( in_array( 'Gutenberg', $available_plugins ) ) { ?>
							<option value="gutenberg"><?php echo esc_html__( 'Gutenberg', 'total-theme-core' ); ?></option>
						<?php } ?>
						<option value="none"><?php echo esc_html__( 'None', 'total-theme-core' ); ?></option>
					</select>
				</div>
				<input class="wpex-demo-import-filter__search" type="text" placeholder="<?php esc_attr_e( 'Search demos...', 'total-theme-core' ); ?>"></input>
			</div>
		<?php endif; ?>

		<button class="wpex-demo-import-refresh-button button button-secondary" data-nonce="<?php echo esc_attr( wp_create_nonce( 'wpex_demos_ajax_refresh_list_nonce' ) ); ?>"><?php
			esc_attr_e( 'Refresh List', 'total-theme-core' );
		?><span class="dashicons dashicons-update-alt" aria-hidden="true"></span></button>

	</div>

	<div class="wpex-demo-import-refresh-notice"><?php
		if ( function_exists( 'wpex_svg' ) ) {
			wpex_svg( 'loaders/wordpress', 18 );
		}
		esc_html_e( 'Your page will refresh momentarily.', 'total-theme-core' );
	?></div>

	<div class="wpex-demo-import-grid"><?php

		if ( ! empty( $this->demos ) && is_array( $this->demos ) ) {

			foreach ( $this->demos as $demo_key => $demo_data ) {

				$categories = '';

				if ( array_key_exists( 'categories', $demo_data ) && is_array( $demo_data['categories'] ) ) {
					$categories = implode( ',', array_keys( $demo_data['categories'] ) );
				}

				$builder = 'none';
				$plugins = $demo_data['plugins'] ?? [];

				if ( is_array( $plugins ) ) {
					if ( in_array( 'WPBakery Page Builder', $plugins ) ) {
						$builder = 'WPBakery';
					} elseif ( in_array( 'Elementor', $plugins ) ) {
						$builder = 'Elementor';
					} elseif ( in_array( 'Gutenberg', $plugins ) ) {
						$builder = 'Gutenberg';
					}
				}

				?>

				<div class="wpex-demo-import-grid-item" data-demo="<?php echo esc_attr( $demo_data['demo_slug'] ); ?>" data-categories="<?php echo esc_attr( $categories ); ?>" data-builder="<?php echo sanitize_html_class( strtolower( $builder ) ); ?>" tabindex="0">

					<?php if ( 'none' !== $builder ) { ?>
						<div class="wpex-demo-import-grid-item__builder-tag"><?php echo esc_html( $builder ); ?></div>
					<?php } ?>

					<div class="wpex-demo-import-grid-item__screenshot">
						<img src="<?php echo esc_url( $demo_data['screenshot'] ); ?>" alt="<?php _e( 'Screenshot', 'total-theme-core' ); ?>" loading="lazy">
						<span class="spinner wpex-demo-spinner"></span>
					</div>

					<h3 class="wpex-demo-import-grid-item__name">
						<span class="wpex-demo-name"><?php echo esc_html( $demo_data['name'] ); ?></span>
						<div class="wpex-demo-import-grid-item__actions">
							<?php
							// Get preview URL
							if ( ! empty( $demo_data['demo_url'] ) ) {
								$demo_preview = $demo_data['demo_url'];
							} else {
								$demo_preview = ! empty( $demo_data['demo_slug'] ) ? 'https://total.wpexplorer.com/' . $demo_data['demo_slug'] . '/' : '';
							} ?>
							<a href="<?php echo esc_url( $demo_preview ); ?>" class="wpex-demo-import-grid-item__button button button-primary" target="_blank"><?php esc_html_e( 'Live Preview', 'total-theme-core' ); ?></a>
						</div>
					</h3>

				</div>

			<?php } ?>

		<?php } ?>

	</div>

	<div class="wpex-demo-import-popup">
		<a href="#" class="wpex-demo-import-popup__close"><span class="screen-reader-text"><?php echo esc_html__( 'Close selected demo', 'total-theme-core' ); ?></span><span class="dashicons dashicons-no-alt"></span></a>
		<div class="wpex-demo-import-popup__inner">
			<div class="wpex-demo-import-popup__content"></div>
		</div>
	</div>

</div>