( function() {
	'use strict';

	const removeImage = () => {
		const thumbnail = document.querySelector( '#wpex_term_thumbnail' );
		if ( ! thumbnail ) {
			return;
		}
		thumbnail.value = '';
		const previewImg = document.querySelector( '#wpex-term-thumbnail-preview img' );
		if ( previewImg ) {
			previewImg.parentNode.removeChild( previewImg );
		}
		const button = document.querySelector( '#wpex-term-thumbnail-remove' );
		if ( button ) {
			button.style.display = 'none';
		}
	};

	// Add image.
	document.addEventListener( 'click', function( event ) {
		const button = event.target.closest( '#wpex-add-term-thumbnail' );
		if ( ! button || 'undefined' === typeof wp ) {
			return;
		}
		event.preventDefault();

		const preview_img = document.querySelector( '#wpex-term-thumbnail-preview img' );

		const image = wp.media( {
			library: {
				type: 'image'
			},
			multiple: false
		} ).on( 'select', function( e ) {
			const selected       = image.state().get( 'selection' ).first();
			const imageID        = selected.toJSON().id;
			const imageURL       = selected.toJSON().url;
			const thumbRemoveBtn = document.querySelector( '#wpex-term-thumbnail-remove' );

			if ( thumbRemoveBtn ) {
				thumbRemoveBtn.style.display = '';
			}

			if ( preview_img ) {
				preview_img.src = imageURL;
			} else {
				const previewContainer = document.querySelector( '#wpex-term-thumbnail-preview' );
				if ( previewContainer ) {
					const imgSize = previewContainer.dataset.imageSize || '40';
					const img = document.createElement( 'img' );
					img.src = imageURL;
					img.setAttribute( 'height', imgSize );
					img.setAttribute( 'width', imgSize );
					img.style.marginTop = '10px';
					previewContainer.appendChild( img );
				}
			}

			const input = document.querySelector( '#wpex_term_thumbnail' );
			if ( input ) {
				input.value = imageID;
			}

		} ).open();
	} );

	// Remove image button.
	document.addEventListener( 'click', function( event ) {
		const button = event.target.closest( '#wpex-term-thumbnail-remove' );
		if ( ! button ) {
			return;
		}
		event.preventDefault();
		removeImage();
	} );

	// Remove image after ajax request.
	if ( 'function' === typeof jQuery ) {
		jQuery( document ).ajaxSuccess(function(event, jqXHR, ajaxOptions) {
			const params = new URLSearchParams( ajaxOptions.data );
			if ( params && params.has( 'action' ) && 'add-tag' === params.get( 'action' ) ) {
				removeImage();
			}
		} );
	}

})();